//------------------------------------------------------------------------------
// <auto-generated />
//
// This file was automatically generated by SWIG (http://www.swig.org).
// Version 3.0.12
//
// Do not make changes to this file unless you know what you are doing--modify
// the SWIG interface file instead.
//------------------------------------------------------------------------------

namespace libsbml {

public class libsbml {


	public static SBMLExtension DowncastExtension(IntPtr cPtr, bool owner)
	{		
		if (cPtr.Equals(IntPtr.Zero)) return null;
		
		SBMLExtension ext = new SBMLExtension(cPtr, false);
		string pkgName = ext.getName();

				
		return new SBMLExtension(cPtr,owner);
	}
	
	public static SBMLNamespaces DowncastSBMLNamespaces(IntPtr cPtr, bool owner)
	{
		if (cPtr.Equals(IntPtr.Zero)) return null;
		
		SBMLNamespaces sbn = new SBMLNamespaces(cPtr, false);
		if (sbn != null)
		{
			XMLNamespaces ns = sbn.getNamespaces();

				
		}
		return new SBMLNamespaces(cPtr, owner);
		
	}
	
	
	public static SBMLConverter DowncastSBMLConverter(IntPtr cPtr, bool owner)
	{
		if (cPtr.Equals(IntPtr.Zero)) return null;
		
		SBMLConverter con = new SBMLConverter(cPtr, false);
		string conName = con.getName();
		
		if (conName == "SBML Units Converter")
		  return new SBMLUnitsConverter(cPtr,owner);
		else if (conName == "SBML Strip Package Converter")
		  return new SBMLStripPackageConverter(cPtr,owner);
		else if (conName == "SBML Rule Converter")
		  return new SBMLRuleConverter(cPtr,owner);
		else if (conName == "SBML Reaction Converter")
		  return new SBMLReactionConverter(cPtr,owner);
		else if (conName == "SBML Local Parameter Converter")
		  return new SBMLLocalParameterConverter(cPtr,owner);
		else if (conName == "SBML Level Version Converter")
		  return new SBMLLevelVersionConverter(cPtr,owner);
		else if (conName == "SBML Initial Assignment Converter")
		  return new SBMLInitialAssignmentConverter(cPtr,owner);
		else if (conName == "SBML Infer Units Converter")
		  return new SBMLInferUnitsConverter(cPtr,owner);
		else if (conName == "SBML Id Converter")
		  return new SBMLIdConverter(cPtr,owner);
		else if (conName == "SBML Function Definition Converter")
		  return new SBMLFunctionDefinitionConverter(cPtr,owner);	

			
		return new SBMLConverter(cPtr,owner);
	}
	
	public static SBasePlugin DowncastSBasePlugin(IntPtr cPtr, bool owner)
	{
		if (cPtr.Equals(IntPtr.Zero)) return null;
		
		SBasePlugin sbp = new SBasePlugin(cPtr, false);
		string pkgName = sbp.getPackageName();
		
		SBMLExtension sbmlext = SBMLExtensionRegistry.getInstance().getExtension(pkgName);
		if (sbmlext != null)
		{
			return sbmlext.DowncastSBasePlugin(cPtr,owner);
		}

		return new SBasePlugin(cPtr,owner);
	}
	

	public static SBase DowncastSBase(IntPtr cPtr, bool owner)
	{
		if (cPtr.Equals(IntPtr.Zero)) return null;
		
		SBase sb = new SBase(cPtr, false);
		string pkgName = sb.getPackageName();
		if (pkgName == "core")
		{
			switch( sb.getTypeCode() )
			{
				case (int) libsbml.SBML_COMPARTMENT:
					return new Compartment(cPtr, owner);
				
				case (int) libsbml.SBML_COMPARTMENT_TYPE:
					return new CompartmentType(cPtr, owner);

				case (int) libsbml.SBML_CONSTRAINT:
					return new Constraint(cPtr, owner);

				case (int) libsbml.SBML_DOCUMENT:
					return new SBMLDocument(cPtr, owner);
	
				case (int) libsbml.SBML_DELAY:
					return new Delay(cPtr, owner);
					
				case (int) libsbml.SBML_EVENT:
					return new Event(cPtr, owner);
					
				case (int) libsbml.SBML_EVENT_ASSIGNMENT:
					return new EventAssignment(cPtr, owner);
					
				case (int) libsbml.SBML_FUNCTION_DEFINITION:
					return new FunctionDefinition(cPtr, owner);
				
				case (int) libsbml.SBML_INITIAL_ASSIGNMENT:
					return new InitialAssignment(cPtr, owner);
					
				case (int) libsbml.SBML_KINETIC_LAW:
					return new KineticLaw(cPtr, owner);
					
				case (int) libsbml.SBML_LIST_OF:
				     string name = sb.getElementName();
				     if(name == "listOf")
			             {
					return new ListOf(cPtr, owner);
				     }
				     else if(name == "listOfCompartments")
				     {
					return new ListOfCompartments(cPtr, owner);
				     }
				     else if(name == "listOfCompartmentTypes")
				     {
					return new ListOfCompartmentTypes(cPtr, owner);
				     }
				     else if(name == "listOfConstraints")
				     {
					return new ListOfConstraints(cPtr, owner);
				     }
				     else if(name == "listOfEvents")
				     {
				         return new ListOfEvents(cPtr, owner);
	                             }
	                             else if(name == "listOfEventAssignments")
	                             {
					return new ListOfEventAssignments(cPtr, owner);
	        		     }
			             else if(name == "listOfFunctionDefinitions")
			             {
	     		               return new ListOfFunctionDefinitions(cPtr, owner);
			             }
			             else if(name == "listOfInitialAssignments")
			             {
			               return new ListOfInitialAssignments(cPtr, owner);
			             }
			             else if(name == "listOfParameters")
			             {
			               return new ListOfParameters(cPtr, owner);
			             }
			             else if(name == "listOfLocalParameters")
			             {
			               return new ListOfLocalParameters(cPtr, owner);
			             }
				     else if(name == "listOfReactions")
			             {
			               return new ListOfReactions(cPtr, owner);
			             }
			             else if(name == "listOfRules")
			             {
			               return new ListOfRules(cPtr, owner);
	                             }
			             else if(name == "listOfSpecies")
			             {
			               return new ListOfSpecies(cPtr, owner);
	                             }
			             else if(name == "listOfUnknowns")
			             {
			               return new ListOfSpeciesReferences(cPtr, owner);
	                             }
			             else if(name == "listOfReactants")
			             {
			               return new ListOfSpeciesReferences(cPtr, owner);
	                             }
			             else if(name == "listOfProducts")
			             {
			               return new ListOfSpeciesReferences(cPtr, owner);
	                             }
			             else if(name == "listOfModifiers")
			             {
			               return new ListOfSpeciesReferences(cPtr, owner);
	                             }
			             else if(name == "listOfSpeciesTypes")
			             {
			               return new ListOfSpeciesTypes(cPtr, owner);
	                             }
			             else if(name == "listOfUnits")
			             {
			               return new ListOfUnits(cPtr, owner);
	                             }
			             else if(name == "listOfUnitDefinitions")
			             {
			               return new ListOfUnitDefinitions(cPtr, owner);
	                             }
			             return new ListOf(cPtr, owner);
					
				case (int) libsbml.SBML_MODEL:
					return new Model(cPtr, owner);
					
				case (int) libsbml.SBML_PARAMETER:
					return new Parameter(cPtr, owner);
					
			case (int) libsbml.SBML_PRIORITY:
				return new Priority(cPtr, owner);
				
				case (int) libsbml.SBML_LOCAL_PARAMETER:
					return new LocalParameter(cPtr, owner);
					
				case (int) libsbml.SBML_REACTION:
					return new Reaction(cPtr, owner);
					
				case (int) libsbml.SBML_SPECIES:
					return new Species(cPtr, owner);
					
				case (int) libsbml.SBML_SPECIES_REFERENCE:
					return new SpeciesReference(cPtr, owner);
					
				case (int) libsbml.SBML_MODIFIER_SPECIES_REFERENCE:
					return new ModifierSpeciesReference(cPtr, owner);
	
				case (int) libsbml.SBML_SPECIES_TYPE:
					return new SpeciesType(cPtr, owner);
	
				case (int) libsbml.SBML_TRIGGER:
					return new Trigger(cPtr, owner);
					
				case (int) libsbml.SBML_UNIT_DEFINITION:
					return new UnitDefinition(cPtr, owner);
					
				case (int) libsbml.SBML_UNIT:
					return new Unit(cPtr, owner);
					
				case (int) libsbml.SBML_ALGEBRAIC_RULE:
					return new AlgebraicRule(cPtr, owner);
					
				case (int) libsbml.SBML_ASSIGNMENT_RULE:
					return new AssignmentRule(cPtr, owner);
					
				case (int) libsbml.SBML_RATE_RULE:
					return new RateRule(cPtr, owner);
	
				case (int) libsbml.SBML_STOICHIOMETRY_MATH:
					return new StoichiometryMath(cPtr, owner);
					
				default:
					return new SBase(cPtr, owner);
			}
		}
		else 
		{
			SBMLExtension sbmlext = SBMLExtensionRegistry.getInstance().getExtension(pkgName);
			if (sbmlext != null)
			{
				return sbmlext.DowncastSBase(cPtr,owner);
			}
		}
		return new SBase(cPtr, owner);
	}
	

	
	public static ASTBase DowncastASTBase(IntPtr cPtr, bool owner)
    {
		if (cPtr.Equals(IntPtr.Zero)) return null;
	
		ASTBase ab = new ASTBase(cPtr,false);
		switch( ab.getTypeCode() )
		{
			default:
			case (int)libsbml.AST_TYPECODE_BASE:
			return new ASTBase(cPtr, owner);
			/*
			case (int)libsbml.AST_TYPECODE_CN_BASE:
			return new ASTCnBase(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_FUNCTION_BASE:
			return new ASTFunctionBase(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_NUMBER:
			return new ASTNumber(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_CN_INTEGER:
			return new ASTCnIntegerNode(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_CN_EXPONENTIAL:
			return new ASTCnExponentialNode(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_CN_RATIONAL:
			return new ASTCnRationalNode(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_CN_REAL:
			return new ASTCnRealNode(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_CSYMBOL:
			return new ASTCSymbol(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_CSYMBOL_AVOGADRO:
			return new ASTCSymbolAvogadroNode(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_CSYMBOL_DELAY:
			return new ASTCSymbolDelayNode(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_CSYMBOL_TIME:
			return new ASTCSymbolTimeNode(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_FUNCTION:
			return new ASTFunction(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_FUNCTION_UNARY:
			return new ASTUnaryFunctionNode(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_FUNCTION_BINARY:
			return new ASTBinaryFunctionNode(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_FUNCTION_NARY:
			return new ASTNaryFunctionNode(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_FUNCTION_PIECEWISE:
			return new ASTPiecewiseFunctionNode(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_FUNCTION_LAMBDA:
			return new ASTLambdaFunctionNode(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_FUNCTION_CI:
			return new ASTCiFunctionNode(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_FUNCTION_SEMANTIC:
			return new ASTSemanticsNode(cPtr, owner);
			case (int)libsbml.AST_TYPECODE_FUNCTION_QUALIFIER:
			return new ASTQualifierNode(cPtr, owner);*/
			case (int)libsbml.AST_TYPECODE_ASTNODE:
			return new ASTNode(cPtr, owner);
	
		}	
		//return new ASTBase(cPtr, owner);
    }




	public static ASTBasePlugin DowncastASTBasePlugin(IntPtr cPtr, bool owner)
	{		
		if (cPtr.Equals(IntPtr.Zero)) return null;
		
		ASTBasePlugin ext = new ASTBasePlugin(cPtr, false);
		string pkgName = ext.getPackageName();

				
		return new ASTBasePlugin(cPtr,owner);
	}


  public static readonly OStream cout = new OStream(OStream.COUT); 
  public static readonly OStream cerr = new OStream(OStream.CERR); 
  public static readonly OStream clog = new OStream(OStream.CLOG); 

  
/**
 * Returns the version number of this copy of libSBML as an integer.
 *
 * @return the libSBML version as an integer; version 1.2.3 becomes 10203.
 */ public
 static int getLibSBMLVersion() {
    int ret = libsbmlPINVOKE.getLibSBMLVersion();
    return ret;
  }

  
/**
 * Returns the version number of this copy of libSBML as a string.
 *
 * @return the libSBML version as a string; version 1.2.3 becomes
 * '1.2.3'.
 *
 * @see getLibSBMLVersionString()
 */ public
 static string getLibSBMLDottedVersion() {
    string ret = libsbmlPINVOKE.getLibSBMLDottedVersion();
    return ret;
  }

  
/**
 * Returns the version number of this copy of libSBML as a string without
 * periods.
 *
 * @return the libSBML version as a string: version 1.2.3 becomes '10203'.
 *
 * @see getLibSBMLDottedVersion()
 */ public
 static string getLibSBMLVersionString() {
    string ret = libsbmlPINVOKE.getLibSBMLVersionString();
    return ret;
  }

  
/**
 * Returns an indication whether libSBML has been compiled with
 * against a specific library. 
 *
 * @param option the library to test against, this can be one of
 *        'expat', 'libxml', 'xerces-c', 'bzip2', 'zip'
 * 
 * @return 0 in case the libSBML has not been compiled against 
 *         that library and non-zero otherwise (for libraries 
 *         that define an integer version number that number will 
 *         be returned).
 *
 * @see getLibSBMLDependencyVersionOf(string option)
 */ public
 static int isLibSBMLCompiledWith(string option) {
    int ret = libsbmlPINVOKE.isLibSBMLCompiledWith(option);
    return ret;
  }

  
/**
 * Returns the version string for the dependency library used. 
 *
 * @param option the library for which the version
 *        should be retrieved, this can be one of
 *        'expat', 'libxml', 'xerces-c', 'bzip2', 'zip'
 * 
 * @return null in case libSBML has not been compiled against 
 *         that library and a version string otherwise.
 *
 * @see isLibSBMLCompiledWith(string option)
 */ public
 static string getLibSBMLDependencyVersionOf(string option) {
    string ret = libsbmlPINVOKE.getLibSBMLDependencyVersionOf(option);
    return ret;
  }

  
/**
 * This method takes an SBML operation return value and returns a string representing
 * the code.
 *
 * @param returnValue the operation return value to convert to a string.
 *
 * @return a human readable name for the given
 * @if clike #OperationReturnValues_t value@else operation return value @endif.
 *
 * @note The caller does not own the returned string and is therefore not
 * allowed to modify it.
 */ public
 static string OperationReturnValue_toString(int returnValue) {
    string ret = libsbmlPINVOKE.OperationReturnValue_toString(returnValue);
    return ret;
  }

  
/**
 *
 * Reads an SBML document from the given file.
 *
 * If the file named @p filename does not exist or its content is not valid
 * SBML, one or more errors will be logged with the SBMLDocument object
 * returned by this method.  Callers can use the methods on SBMLDocument such
 * as
 * @if python @link libsbml.SBMLDocument.getNumErrors() SBMLDocument.getNumErrors()@endlink@endif,
 * @if conly SBMLDocument_getNumErrors() @else SBMLDocument::getNumErrors()@endif
 * and
 * @if python @link libsbml.SBMLDocument.getError() SBMLDocument.getError()@endlink@endif
 * @if java SBMLDocument::getError(long)@endif
 * @if cpp SBMLDocument::getError()@endif
 * @if csharp SBMLDocument::getError()@endif
 * @if conly SBMLDocument_getError()@endif
 * to get the errors.  The object returned by
 * @if python @link libsbml.SBMLDocument.getError() SBMLDocument.getError()@endlink@endif
 * @if java SBMLDocument::getError(long)@endif
 * @if cpp SBMLDocument::getError()@endif
 * @if csharp SBMLDocument::getError()@endif
 * @if conly SBMLDocument_getError()@endif
 * is an SBMLError object, and it has methods to get the error code,
 * category, and severity level of the problem, as well as a textual
 * description of the problem.  The possible severity levels range from
 * informational messages to fatal errors; see the documentation for
 * @if conly SBMLError_t @else SBMLError@endif
 * for more information.
 *
 * If the file @p filename could not be read, the file-reading error will
 * appear first.  The error code @if clike (a value drawn from the
 * enumeration #XMLErrorCode_t)@endif can provide a clue about what
 * happened.  For example, a file might be unreadable (either because it does
 * not actually exist or because the user does not have the necessary access
 * privileges to read it) or some sort of file operation error may have been
 * reported by the underlying operating system.  Callers can check for these
 * situations using a program fragment such as the following:
 * @if cpp
@code{.cpp}
SBMLReader reader;
SBMLDocument doc  = reader.readSBMLFromFile(filename);

if (doc->getNumErrors() > 0)
{
  if (doc->getError(0)->getErrorId() == XMLError::XMLFileUnreadable)
  {
    // Handle case of unreadable file here.
  }
  else if (doc->getError(0)->getErrorId() == XMLError::XMLFileOperationError)
  {
    // Handle case of other file operation error here.
  }
  else
  {
    // Handle other cases -- see error codes defined in XMLErrorCode_t
    // for other possible cases to check.
  }
}
@endcode
@endif
@if conly
@code{.c}
SBMLReader_t   *sr;
SBMLDocument_t *d;

sr = SBMLReader_create();

d = SBMLReader_readSBML(sr, filename);

if (SBMLDocument_getNumErrors(d) > 0)
{
  if (XMLError_getId(SBMLDocument_getError(d, 0))
      == SBML_READ_ERROR_FILE_NOT_FOUND)
  {
     ...
  }
  if (XMLError_getId(SBMLDocument_getError(d, 0))
      == SBML_READ_ERROR_NOT_SBML)
  {
     ...
  }
}
@endcode
@endif
@if java
@code{.java}
SBMLReader reader = new SBMLReader();
SBMLDocument doc  = reader.readSBMLFromFile(filename);

if (doc.getNumErrors() > 0)
{
    if (doc.getError(0).getErrorId() == libsbml.libsbml.XMLFileUnreadable)
    {
        // Handle case of unreadable file here.
    }
    else if (doc.getError(0).getErrorId() == libsbml.libsbml.XMLFileOperationError)
    {
        // Handle case of other file operation error here.
    }
    else
    {
        // Handle other error cases.
    }
}
@endcode
@endif
@if python
@code{.py}
reader = SBMLReader()
if reader == None:
  # Handle the truly exceptional case of no object created here.

doc = reader.readSBMLFromFile(filename)
if doc.getNumErrors() > 0:
  if doc.getError(0).getErrorId() == XMLFileUnreadable:
    # Handle case of unreadable file here.
  elif doc.getError(0).getErrorId() == XMLFileOperationError:
    # Handle case of other file error here.
  else:
    # Handle other error cases here.
@endcode
@endif
@if csharp
@code{.cs}
SBMLReader reader = new SBMLReader();
SBMLDocument doc = reader.readSBMLFromFile(filename);

if (doc.getNumErrors() > 0)
{
    if (doc.getError(0).getErrorId() == libsbmlcs.libsbml.XMLFileUnreadable)
    {
         // Handle case of unreadable file here.
    }
    else if (doc.getError(0).getErrorId() == libsbmlcs.libsbml.XMLFileOperationError)
    {
         // Handle case of other file operation error here.
    }
    else
    {
         // Handle other cases -- see error codes defined in XMLErrorCode_t
         // for other possible cases to check.
    }
 }
@endcode
@endif
 *
 *
 * 
 * If the given filename ends with the suffix @c '.gz' (for example,
 * @c 'myfile.xml.gz'), the file is assumed to be compressed in @em gzip
 * format and will be automatically decompressed upon reading.
 * Similarly, if the given filename ends with @c '.zip' or @c '.bz2', the
 * file is assumed to be compressed in @em zip or @em bzip2 format
 * (respectively).  Files whose names lack these suffixes will be read
 * uncompressed.  Note that if the file is in @em zip format but the
 * archive contains more than one file, only the first file in the
 * archive will be read and the rest ignored.
 *
 *
 *
 *
 * 
 * To read a gzip/zip file, libSBML needs to be configured and linked with the
 * <a target='_blank' href='http://www.zlib.net/'>zlib</a> library at compile
 * time.  It also needs to be linked with the <a target='_blank'
 * href=''>bzip2</a> library to read files in <em>bzip2</em> format.  (Both of
 * these are the default configurations for libSBML.)  Errors about unreadable
 * files will be logged if a compressed filename is given and libSBML was
 * <em>not</em> linked with the corresponding required library.
 *
 *
 *
 *
 *
 * @if conly
 * @memberof SBMLReader_t
 * @endif
 */ public
 static SBMLDocument readSBML(string filename) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.readSBML(filename);
    SBMLDocument ret = (cPtr == global::System.IntPtr.Zero) ? null : new SBMLDocument(cPtr, true);
    return ret;
  }

  
/**
 *
 * Reads an SBML document from the given file.
 *
 * If the file named @p filename does not exist or its content is not valid
 * SBML, one or more errors will be logged with the SBMLDocument object
 * returned by this method.  Callers can use the methods on SBMLDocument such
 * as
 * @if python @link libsbml.SBMLDocument.getNumErrors() SBMLDocument.getNumErrors()@endlink@endif,
 * @if conly SBMLDocument_getNumErrors() @else SBMLDocument::getNumErrors()@endif
 * and
 * @if python @link libsbml.SBMLDocument.getError() SBMLDocument.getError()@endlink@endif
 * @if java SBMLDocument::getError(long)@endif
 * @if cpp SBMLDocument::getError()@endif
 * @if csharp SBMLDocument::getError()@endif
 * @if conly SBMLDocument_getError()@endif
 * to get the errors.  The object returned by
 * @if python @link libsbml.SBMLDocument.getError() SBMLDocument.getError()@endlink@endif
 * @if java SBMLDocument::getError(long)@endif
 * @if cpp SBMLDocument::getError()@endif
 * @if csharp SBMLDocument::getError()@endif
 * @if conly SBMLDocument_getError()@endif
 * is an SBMLError object, and it has methods to get the error code,
 * category, and severity level of the problem, as well as a textual
 * description of the problem.  The possible severity levels range from
 * informational messages to fatal errors; see the documentation for
 * @if conly SBMLError_t @else SBMLError@endif
 * for more information.
 *
 * If the file @p filename could not be read, the file-reading error will
 * appear first.  The error code @if clike (a value drawn from the
 * enumeration #XMLErrorCode_t)@endif can provide a clue about what
 * happened.  For example, a file might be unreadable (either because it does
 * not actually exist or because the user does not have the necessary access
 * privileges to read it) or some sort of file operation error may have been
 * reported by the underlying operating system.  Callers can check for these
 * situations using a program fragment such as the following:
 * @if cpp
@code{.cpp}
SBMLReader reader;
SBMLDocument doc  = reader.readSBMLFromFile(filename);

if (doc->getNumErrors() > 0)
{
  if (doc->getError(0)->getErrorId() == XMLError::XMLFileUnreadable)
  {
    // Handle case of unreadable file here.
  }
  else if (doc->getError(0)->getErrorId() == XMLError::XMLFileOperationError)
  {
    // Handle case of other file operation error here.
  }
  else
  {
    // Handle other cases -- see error codes defined in XMLErrorCode_t
    // for other possible cases to check.
  }
}
@endcode
@endif
@if conly
@code{.c}
SBMLReader_t   *sr;
SBMLDocument_t *d;

sr = SBMLReader_create();

d = SBMLReader_readSBML(sr, filename);

if (SBMLDocument_getNumErrors(d) > 0)
{
  if (XMLError_getId(SBMLDocument_getError(d, 0))
      == SBML_READ_ERROR_FILE_NOT_FOUND)
  {
     ...
  }
  if (XMLError_getId(SBMLDocument_getError(d, 0))
      == SBML_READ_ERROR_NOT_SBML)
  {
     ...
  }
}
@endcode
@endif
@if java
@code{.java}
SBMLReader reader = new SBMLReader();
SBMLDocument doc  = reader.readSBMLFromFile(filename);

if (doc.getNumErrors() > 0)
{
    if (doc.getError(0).getErrorId() == libsbml.libsbml.XMLFileUnreadable)
    {
        // Handle case of unreadable file here.
    }
    else if (doc.getError(0).getErrorId() == libsbml.libsbml.XMLFileOperationError)
    {
        // Handle case of other file operation error here.
    }
    else
    {
        // Handle other error cases.
    }
}
@endcode
@endif
@if python
@code{.py}
reader = SBMLReader()
if reader == None:
  # Handle the truly exceptional case of no object created here.

doc = reader.readSBMLFromFile(filename)
if doc.getNumErrors() > 0:
  if doc.getError(0).getErrorId() == XMLFileUnreadable:
    # Handle case of unreadable file here.
  elif doc.getError(0).getErrorId() == XMLFileOperationError:
    # Handle case of other file error here.
  else:
    # Handle other error cases here.
@endcode
@endif
@if csharp
@code{.cs}
SBMLReader reader = new SBMLReader();
SBMLDocument doc = reader.readSBMLFromFile(filename);

if (doc.getNumErrors() > 0)
{
    if (doc.getError(0).getErrorId() == libsbmlcs.libsbml.XMLFileUnreadable)
    {
         // Handle case of unreadable file here.
    }
    else if (doc.getError(0).getErrorId() == libsbmlcs.libsbml.XMLFileOperationError)
    {
         // Handle case of other file operation error here.
    }
    else
    {
         // Handle other cases -- see error codes defined in XMLErrorCode_t
         // for other possible cases to check.
    }
 }
@endcode
@endif
 *
 *
 * 
 * If the given filename ends with the suffix @c '.gz' (for example,
 * @c 'myfile.xml.gz'), the file is assumed to be compressed in @em gzip
 * format and will be automatically decompressed upon reading.
 * Similarly, if the given filename ends with @c '.zip' or @c '.bz2', the
 * file is assumed to be compressed in @em zip or @em bzip2 format
 * (respectively).  Files whose names lack these suffixes will be read
 * uncompressed.  Note that if the file is in @em zip format but the
 * archive contains more than one file, only the first file in the
 * archive will be read and the rest ignored.
 *
 *
 *
 *
 * 
 * To read a gzip/zip file, libSBML needs to be configured and linked with the
 * <a target='_blank' href='http://www.zlib.net/'>zlib</a> library at compile
 * time.  It also needs to be linked with the <a target='_blank'
 * href=''>bzip2</a> library to read files in <em>bzip2</em> format.  (Both of
 * these are the default configurations for libSBML.)  Errors about unreadable
 * files will be logged if a compressed filename is given and libSBML was
 * <em>not</em> linked with the corresponding required library.
 *
 *
 *
 *
 *
 * @param filename the name or full pathname of the file to be read.
 *
 * @return a pointer to the SBMLDocument structure created from the SBML
 * content in @p filename.
 *
 * @if conly
 * @memberof SBMLReader_t
 * @endif
 */ public
 static SBMLDocument readSBMLFromFile(string filename) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.readSBMLFromFile(filename);
    SBMLDocument ret = (cPtr == global::System.IntPtr.Zero) ? null : new SBMLDocument(cPtr, true);
    return ret;
  }

  
/**
 *
 * Reads an SBML document from a text string.
 *
 * This method is flexible with respect to the presence of an XML
 * declaration at the beginning of the string.  In particular, if the
 * string in @p xml does not begin with the XML declaration
 * @verbatim
<?xml version='1.0' encoding='UTF-8'?>
@endverbatim
 * then this method will automatically prepend the declaration
 * to @p xml.
 *
 * This method will log a fatal error if the content given in the parameter
 * @p xml is not in SBML format.  See the method documentation for
 * @if conly SBMLReader_readSBML() 
 * @elseif java SBMLReader::readSBML( String )
 * @else SBMLReader::readSBML()
 * @endif
 * for an example of code for testing the returned error code.
 *
 *
 *
 * @param xml a string containing a full SBML model.
 *
 * @return a pointer to the SBMLDocument structure created from the SBML
 * content in @p xml.
 *
 *
 * @note When using this method to read an SBMLDocument that uses the SBML
 * Level&nbsp;3 Hierarchical %Model Composition package (comp) the document
 * location cannot be set automatically. Thus, if the model contains
 * references to ExternalModelDefinition objects, it will be necessary to
 * manually set the document URI location
 * (@if conly SBMLDocument_setLocationURI()
 * @elseif java SBMLDocument::setLocationURI( String ) 
 * @else SBMLDocument::setLocationURI()
 * @endif
 * ) in order to facilitate resolving these models.
 *
 * @if conly
 * @memberof SBMLReader_t
 * @endif
 */ public
 static SBMLDocument readSBMLFromString(string xml) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.readSBMLFromString(xml);
    SBMLDocument ret = (cPtr == global::System.IntPtr.Zero) ? null : new SBMLDocument(cPtr, true);
    return ret;
  }

  
/**
 * Writes the given SBML document @p d to the file named by @p filename.
 * This convenience function is functionally equivalent to:
 *
 *   SBMLWriter_writeSBML(SBMLWriter_create(), d, filename);
 *
 * @htmlinclude assuming-compressed-file.html
 *
 * @param d the SBMLDocument object to be written out in XML format.
 * 
 * @param filename a string giving the path to a file where the XML
 * content is to be written.
 *
 * @return @c 1 (true) on success and @c 0 (false) if @p filename could not be
 * written.  Some possible reasons for failure include (a) being unable to
 * open the file, and (b) using a filename that indicates a compressed SBML
 * file (i.e., a filename ending in <code>&quot;.zip&quot;</code> or
 * similar) when the compression functionality has not been enabled in
 * the underlying copy of libSBML.
 *
 * @see @if conly SBMLWriter_hasZlib() @else SBMLWriter::hasZlib() @endif
 * @see @if conly SBMLWriter_hasBzip2() @else SBMLWriter::hasBzip2() @endif
 *
 * @if conly
 * @memberof SBMLWriter_t
 * @endif
 */ public
 static int writeSBML(SBMLDocument d, string filename) {
    int ret = libsbmlPINVOKE.writeSBML(SBMLDocument.getCPtr(d), filename);
    return ret;
  }

  
/**
 * Writes the given SBML document @p d to an in-memory string and returns a
 * pointer to it.  The string is owned by the caller and should be freed
 * (with free()) when no longer needed.  This convenience function is
 * functionally equivalent to:
 *
 *   SBMLWriter_writeSBMLToString(SBMLWriter_create(), d);
 *
 * but does not require the caller to create an SBMLWriter object first.
 *
 * @param d an SBMLDocument object to be written out in XML format.
 *
 * @return the string on success and @c null if one of the underlying parser
 * components fail.
 *
 * @if clike @warning Note that the string is owned by the caller and
 * should be freed after it is no longer needed.@endif
 *
 * @if conly
 * @memberof SBMLWriter_t
 * @endif
 */ public
 static string writeSBMLToString(SBMLDocument d) {
    string ret = libsbmlPINVOKE.writeSBMLToString(SBMLDocument.getCPtr(d));
    return ret;
  }

  
/**
 * Writes the given SBML document @p d to the file @p filename.
 * This convenience function is functionally equivalent to:
 *
 *   SBMLWriter_writeSBMLToFile(SBMLWriter_create(), d, filename);
 *
 * but that does not require the caller to create an SBMLWriter object first.
 *
 * @htmlinclude assuming-compressed-file.html
 * 
 * @param d an SBMLDocument object to be written out in XML format.
 *
 * @param filename a string giving the path to a file where the XML
 * content is to be written.
 *
 * @return @c 1 (true) on success and @c 0 (false) if @p filename could not be
 * written.  Some possible reasons for failure include (a) being unable to
 * open the file, and (b) using a filename that indicates a compressed SBML
 * file (i.e., a filename ending in <code>&quot;.zip&quot;</code> or
 * similar) when the compression functionality has not been enabled in
 * the underlying copy of libSBML.
 *
 * @if clike @warning Note that the string is owned by the caller and
 * should be freed (with the normal string <code>free()</code> C++
 * function) after it is no longer needed.@endif
 *
 * @see SBMLWriter::hasZlib()
 * @see SBMLWriter::hasBzip2()
 *
 * @if conly
 * @memberof SBMLWriter_t
 * @endif
 */ public
 static int writeSBMLToFile(SBMLDocument d, string filename) {
    int ret = libsbmlPINVOKE.writeSBMLToFile(SBMLDocument.getCPtr(d), filename);
    return ret;
  }

  
/**
 * This method takes an SBML type code and returns a string representing
 * the code.
 *
 * @if clike LibSBML attaches an identifying code to every kind of SBML
 * object.  These are known as <em>SBML type codes</em>.  The set of
 * possible type codes is defined in the enumeration #SBMLTypeCode_t.
 * The names of the type codes all begin with the characters
 * @c SBML_. @endif@if java LibSBML attaches an identifying code to every
 * kind of SBML object.  These are known as <em>SBML type codes</em>.  In
 * other languages, the set of type codes is stored in an enumeration; in
 * the Java language interface for libSBML, the type codes are defined as
 * static integer constants in the interface class {@link
 * libsbmlConstants}.  The names of the type codes all begin with the
 * characters @c SBML_. @endif@if python LibSBML attaches an identifying
 * code to every kind of SBML object.  These are known as <em>SBML type
 * codes</em>.  In the Python language interface for libSBML, the type
 * codes are defined as static integer constants in the interface class
 * @link libsbml@endlink.  The names of the type codes all begin with the
 * characters @c SBML_. @endif@if csharp LibSBML attaches an identifying
 * code to every kind of SBML object.  These are known as <em>SBML type
 * codes</em>.  In the C# language interface for libSBML, the type codes
 * are defined as static integer constants in the interface class @link
 * libsbml@endlink.  The names of the type codes all begin with
 * the characters @c SBML_. @endif
 *
 * @return a human readable name for the given
 * @if clike #SBMLTypeCode_t value@else SBML type code@endif.
 *
 * @note The caller does not own the returned string and is therefore not
 * allowed to modify it.
 *
 */ public
 static string SBMLTypeCode_toString(int tc, string pkgName) {
    string ret = libsbmlPINVOKE.SBMLTypeCode_toString(tc, pkgName);
    return ret;
  }

  
/**
 * Tests for logical equality between two given <code>UNIT_KIND_</code>
 * code values.
 *
 * This function behaves exactly like C's <code>==</code> operator, except
 * for the following two cases:
 * <ul>
  * <li>@link libsbml#UNIT_KIND_LITER UNIT_KIND_LITER@endlink <code>==</code> @link libsbml#UNIT_KIND_LITRE UNIT_KIND_LITRE@endlink
 * <li>@link libsbml#UNIT_KIND_METER UNIT_KIND_METER@endlink <code>==</code> @link libsbml#UNIT_KIND_METRE UNIT_KIND_METRE@endlink
 * </ul>
 *
 * In the two cases above, C equality comparison would yield @c 0 (false)
 * (because each of the above is a distinct enumeration value), but
 * this function returns @c true.
 *
 * @param uk1 a <code>UNIT_KIND_</code> value.
 * @param uk2 a second <code>UNIT_KIND_</code> value to compare to @p uk1.
 *
 * @return @c 1 (true) if @p uk1 is logically equivalent to @p
 * uk2, @c 0 (false) otherwise.
 *
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for Unit.
 *
 * @if conly
 * @memberof Unit_t
 * @endif
 */ public
 static int UnitKind_equals(int uk1, int uk2) {
    int ret = libsbmlPINVOKE.UnitKind_equals(uk1, uk2);
    return ret;
  }

  
/**
 * Converts a text string naming a kind of unit to its corresponding
 * libSBML <code>UNIT_KIND_</code> constant/enumeration value.
 *
 * @param name a string, the name of a predefined base unit in SBML.
 * 
 * @return @if clike a value from UnitKind_t corresponding to the given
 * string @p name (determined in a case-insensitive manner).
 * @endif@if python a value the set of <code>UNIT_KIND_</code> codes
 * defined in class @link libsbml libsbml@endlink, corresponding to the
 * string @p name (determined in a case-insensitive
 * manner).@endif@if java a value the set of <code>UNIT_KIND_</code> codes
 * defined in class {@link libsbmlConstants}, corresponding to the string
 * @p name (determined in a case-insensitive manner).@endif
 *
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for Unit.
 *
 * @if conly
 * @memberof Unit_t
 * @endif
 */ public
 static int UnitKind_forName(string name) {
    int ret = libsbmlPINVOKE.UnitKind_forName(name);
    return ret;
  }

  
/**
 * Converts a unit code to a text string equivalent.
 *
 * @param uk @if clike a value from the UnitKind_t enumeration
 * @endif@if python a value from the set of <code>UNIT_KIND_</code> codes
 * defined in the class @link libsbml libsbml@endlink
 * @endif@if java a value from the set of <code>UNIT_KIND_</code> codes
 * defined in the class {@link libsbmlConstants}
 * @endif
 *
 * @return the name corresponding to the given unit code.
 *
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for Unit.
 * 
 * @warning The string returned is a static data value.  The caller does not
 * own the returned string and is therefore not allowed to modify it.
 *
 * @if conly
 * @memberof Unit_t
 * @endif
 */ public
 static string UnitKind_toString(int uk) {
    string ret = libsbmlPINVOKE.UnitKind_toString(uk);
    return ret;
  }

  
/**
 * Predicate for testing whether a given string corresponds to a
 * predefined libSBML unit code.
 *
 * @param str a text string naming a base unit defined by SBML.
 * @param level the Level of SBML.
 * @param version the Version within the Level of SBML.
 *
 * @return 1 (true) if string is the name of a valid
 * <code>UNIT_KIND_</code> value, @c 0 (false) otherwise.
 *
 * @note For more information about the libSBML unit codes, please refer to
 * the class documentation for Unit.
 *
 * @if conly
 * @memberof Unit_t
 * @endif
 */ public
 static int UnitKind_isValidUnitKindString(string str, long level, long version) {
    int ret = libsbmlPINVOKE.UnitKind_isValidUnitKindString(str, level, version);
    return ret;
  }

  
/**
 * This method takes a model qualifier type code and returns a string
 * representing the code.
 *
 * This method takes a model qualifier type as argument
 * and returns a string name corresponding to that code.  For example,
 * passing it the qualifier @link libsbml#BQM_IS_DESCRIBED_BY BQM_IS_DESCRIBED_BY@endlink will return
 * the string <code>'isDescribedBy'</code>.
 *
 * @param type the @if clike ModelQualifierType_t@endif value to
 * translate. @ifnot clike The value should be a libSBML constant whose
 * name begins with @c BQM_, such as (for example)
 * @link libsbml#BQM_IS BQM_IS@endlink.@endif
 *
 * @return a human readable qualifier name for the given qualifier type.
 *
 * @note The caller does not own the returned string and is therefore not
 * allowed to modify it.
 *
 * @if conly
 * @memberof CVTerm_t
 * @endif
 */ public
 static string ModelQualifierType_toString(int type) {
    string ret = libsbmlPINVOKE.ModelQualifierType_toString(type);
    return ret;
  }

  
/**
 * This method takes a biol qualifier type code and returns a string
 * representing the code.
 *
 * This method takes a biol qualifier type as argument
 * and returns a string name corresponding to that code.  For example,
 * passing it the qualifier @link libsbml#BQB_HAS_VERSION BQB_HAS_VERSION@endlink will return
 * the string <code>'hasVersion'</code>.
 *
 * @param type the @if clike #BiolQualifierType_t@endif value to
 * translate. @ifnot clike The value should be a constant whose name
 * begins with @c BQB_, such as (for example)
 * @link libsbml#BQB_IS BQB_IS@endlink.@endif
 *
 * @return a human readable qualifier name for the given type.
 *
 * @note The caller does not own the returned string and is therefore not
 * allowed to modify it.
 *
 * @if conly
 * @memberof CVTerm_t
 * @endif
 */ public
 static string BiolQualifierType_toString(int type) {
    string ret = libsbmlPINVOKE.BiolQualifierType_toString(type);
    return ret;
  }

  
/**
 * This method takes a string and returns a model qualifier
 * representing the string.
 *
 * This method takes a string as argument and returns a model qualifier type
 * corresponding to that string.  For example, passing it the string
 * <code>'isDescribedBy'</code> will return the qualifier
 * @link libsbml#BQM_IS_DESCRIBED_BY BQM_IS_DESCRIBED_BY@endlink.
 *
 * @param s the string to translate to a @if clike #ModelQualifierType_t
 * value@else libSBML constant value representing a model qualifier@endif.
 *
 * @return a libSBML qualifier enumeration value for the given human readable
 * qualifier name.
 *
 * @if conly
 * @memberof CVTerm_t
 * @endif
 */ public
 static int ModelQualifierType_fromString(string s) {
    int ret = libsbmlPINVOKE.ModelQualifierType_fromString(s);
    return ret;
  }

  
/**
 * This method takes a string and returns a biol qualifier
 * representing the string.
 *
 * This method takes a string as argument and returns a biol qualifier type
 * corresponding to that string.  For example, passing it the string
 * <code>'hasVersion'</code> will return the qualifier
 * @link libsbml#BQB_HAS_VERSION BQB_HAS_VERSION@endlink.
 *
 * @param s the string to translate to a @if clike #BiolQualifierType_t
 * value@else libSBML constant value representing a biological qualifier@endif.
 *
 * @return a libSBML qualifier enumeration value for the given human readable
 * qualifier name.
 *
 * @if conly
 * @memberof CVTerm_t
 * @endif
 */ public
 static int BiolQualifierType_fromString(string s) {
    int ret = libsbmlPINVOKE.BiolQualifierType_fromString(s);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static bool representsNumber(int type) {
    bool ret = libsbmlPINVOKE.representsNumber(type);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static bool representsFunction(int type, ASTBasePlugin plugin) {
    bool ret = libsbmlPINVOKE.representsFunction__SWIG_0(type, ASTBasePlugin.getCPtr(plugin));
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static bool representsFunction(int type) {
    bool ret = libsbmlPINVOKE.representsFunction__SWIG_1(type);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static bool representsUnaryFunction(int type, ASTBasePlugin plugin) {
    bool ret = libsbmlPINVOKE.representsUnaryFunction__SWIG_0(type, ASTBasePlugin.getCPtr(plugin));
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static bool representsUnaryFunction(int type) {
    bool ret = libsbmlPINVOKE.representsUnaryFunction__SWIG_1(type);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static bool representsBinaryFunction(int type, ASTBasePlugin plugin) {
    bool ret = libsbmlPINVOKE.representsBinaryFunction__SWIG_0(type, ASTBasePlugin.getCPtr(plugin));
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static bool representsBinaryFunction(int type) {
    bool ret = libsbmlPINVOKE.representsBinaryFunction__SWIG_1(type);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static bool representsNaryFunction(int type, ASTBasePlugin plugin) {
    bool ret = libsbmlPINVOKE.representsNaryFunction__SWIG_0(type, ASTBasePlugin.getCPtr(plugin));
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static bool representsNaryFunction(int type) {
    bool ret = libsbmlPINVOKE.representsNaryFunction__SWIG_1(type);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static bool representsQualifier(int type, ASTBasePlugin plugin) {
    bool ret = libsbmlPINVOKE.representsQualifier__SWIG_0(type, ASTBasePlugin.getCPtr(plugin));
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static bool representsQualifier(int type) {
    bool ret = libsbmlPINVOKE.representsQualifier__SWIG_1(type);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static bool representsFunctionRequiringAtLeastTwoArguments(int type) {
    bool ret = libsbmlPINVOKE.representsFunctionRequiringAtLeastTwoArguments(type);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static int getCoreTypeFromName(string name) {
    int ret = libsbmlPINVOKE.getCoreTypeFromName(name);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static string getNameFromCoreType(int type) {
    string ret = libsbmlPINVOKE.getNameFromCoreType(type);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static bool isCoreTopLevelMathMLFunctionNodeTag(string name) {
    bool ret = libsbmlPINVOKE.isCoreTopLevelMathMLFunctionNodeTag(name);
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static bool isCoreTopLevelMathMLNumberNodeTag(string name) {
    bool ret = libsbmlPINVOKE.isCoreTopLevelMathMLNumberNodeTag(name);
    return ret;
  }

  
/**
 * Reads the MathML from the given XML string, constructs a corresponding
 * abstract syntax tree, and returns a pointer to the root of the tree.
 *
 * @param xml a string containing a full MathML expression.
 *
 * @return the root of an AST corresponding to the given mathematical
 * expression, otherwise @c null is returned if the given string is @c null
 * or invalid.
 *
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */ public
 static ASTNode readMathMLFromString(string xml) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.readMathMLFromString(xml);
    ASTNode ret = (cPtr == global::System.IntPtr.Zero) ? null : new ASTNode(cPtr, true);
    return ret;
  }

  
/**
 * Reads the MathML from the given XML string, constructs a corresponding
 * abstract syntax tree, and returns a pointer to the root of the tree.
 *
 * @param xml a string containing a full MathML expression.
 * @param xmlns an @if conly XMLNamespaces_t structure @else XMLNamespaces
 * object@endif containing namespaces that are considered active during the
 * read. (For example, an SBML Level&nbsp;3 package namespace.)
 *
 * @return the root of an AST corresponding to the given mathematical
 * expression, otherwise @c null is returned if the given string is @c null
 * or invalid.
 *
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */ public
 static ASTNode readMathMLFromStringWithNamespaces(string xml, XMLNamespaces xmlns) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.readMathMLFromStringWithNamespaces(xml, XMLNamespaces.getCPtr(xmlns));
    ASTNode ret = (cPtr == global::System.IntPtr.Zero) ? null : new ASTNode(cPtr, false);
    return ret;
  }

  
/**
 * Writes the given AST node (and its children) to a string as MathML, and
 * returns the string.
 *
 * @param node the root of an AST to write out to the stream.
 *
 * @return a string containing the written-out MathML representation
 * of the given AST.
 *
 * @note The string is owned by the caller and should be freed (with
 * free()) when no longer needed.  @c null is returned if the given
 * argument is @c null.
 *
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */ public
 static string writeMathMLToString(ASTNode node) {
    string ret = libsbmlPINVOKE.writeMathMLToString(ASTNode.getCPtr(node));
    return ret;
  }

  
/**
 * Writes the given AST node (and its children) to a string as MathML, and
 * returns the string.
 *
 * @param node the root of an AST to write out to the stream.
 * @param sbmlns the SBML namespace to be used
 *
 * @return a string containing the written-out MathML representation
 * of the given AST.
 *
 * @note The string is owned by the caller and should be freed (with
 * free()) when no longer needed.  @c null is returned if the given
 * argument is @c null.
 *
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */ public
 static string writeMathMLWithNamespaceToString(ASTNode node, SBMLNamespaces sbmlns) {
    string ret = libsbmlPINVOKE.writeMathMLWithNamespaceToString(ASTNode.getCPtr(node), SBMLNamespaces.getCPtr(sbmlns));
    return ret;
  }

  
/**
 * Parses a text string as a mathematical formula and returns an AST
 * representation of it.
 *
 *
 * 
 * The text-string form of mathematical formulas produced by
 * @sbmlfunction{formulaToString, ASTNode} and read by
 * @sbmlfunction{parseFormula, String} use a simple C-inspired infix
 * notation taken from SBML Level&nbsp;1.  A formula in this text-string form
 * therefore can be handed to a program that understands SBML Level&nbsp;1
 * mathematical expressions, or used as part of a formula translation system.
 * The syntax is described in detail in the documentation for ASTNode.  The
 * following are illustrative examples of formulas expressed using this syntax:
 * @verbatim
0.10 * k4^2
@endverbatim
@verbatim
(vm * s1)/(km + s1)
@endverbatim
 *
 * Note that this facility is provided as a convenience by libSBML---the
 * MathML standard does not actually define a 'string-form' equivalent to
 * MathML expression trees, so the choice of formula syntax is somewhat
 * arbitrary.  The approach taken by libSBML is to use the syntax defined by
 * SBML Level&nbsp;1 (which in fact used a text-string representation of
 * formulas and not MathML).  This formula syntax is based mostly on C
 * programming syntax, and may contain operators, function calls, symbols,
 * and white space characters.  The following table provides the precedence
 * rules for the different entities that may appear in formula strings.
 *
 * @htmlinclude math-precedence-table.html
 *
 * In the table above, @em operand implies the construct is an operand, @em
 * prefix implies the operation is applied to the following arguments, @em
 * unary implies there is one argument, and @em binary implies there are
 * two arguments.  The values in the <b>Precedence</b> column show how the
 * order of different types of operation are determined.  For example, the
 * expression <code>a * b + c</code> is evaluated as <code>(a * b) +
 * c</code> because the @c * operator has higher precedence.  The
 * <b>Associates</b> column shows how the order of similar precedence
 * operations is determined; for example, <code>a - b + c</code> is
 * evaluated as <code>(a - b) + c</code> because the @c + and @c -
 * operators are left-associative.
 *
 * The function call syntax consists of a function name, followed by optional
 * white space, followed by an opening parenthesis token, followed by a
 * sequence of zero or more arguments separated by commas (with each comma
 * optionally preceded and/or followed by zero or more white space
 * characters, followed by a closing parenthesis token.  The function name
 * must be chosen from one of the pre-defined functions in SBML or a
 * user-defined function in the model.  The following table lists the names
 * of certain common mathematical functions; this table corresponds to
 * Table&nbsp;6 in the <a target='_blank' href='http://sbml.org/Documents/Specifications#SBML_Level_1_Version_2'>SBML Level&nbsp;1 Version&nbsp;2 specification</a>:
 *
 * @htmlinclude string-functions-table.html
 *
 * @warning <span class='warning'>There are differences between the symbols
 * used to represent the common mathematical functions and the corresponding
 * MathML token names.  This is a potential source of incompatibilities.
 * Note in particular that in this text-string syntax, <code>log(x)</code>
 * represents the natural logarithm, whereas in MathML, the natural logarithm
 * is <code>&lt;ln/&gt;</code>.  Application writers are urged to be careful
 * when translating between text forms and MathML forms, especially if they
 * provide a direct text-string input facility to users of their software
 * systems.</span>
 *
 *
 *
 * @param formula the text-string formula expression to be parsed.
 *
 * @return the root node of the AST corresponding to the @p formula, or
 * @c null if an error occurred in parsing the formula
 *
 * @see @sbmlfunction{parseL3Formula, String}
 * @see @sbmlfunction{formulaToString, ASTNode}
 * @see @sbmlfunction{formulaToL3String, ASTNode}
 * @see @sbmlfunction{formulaToL3StringWithSettings, ASTNode\, L3ParserSettings}
 * @see @sbmlfunction{parseL3FormulaWithSettings, String\, L3ParserSettings}
 * @see @sbmlfunction{parseL3FormulaWithModel, String\, Model}
 * @see L3ParserSettings
 *
 *
 * @note
 * Callers using SBML Level&nbsp;3 are encouraged to use the facilities
 * provided by libSBML's newer and more powerful Level&nbsp;3-oriented
 * formula parser and formatter.  The entry points to this second system are
 * @sbmlfunction{parseL3Formula, String} and
 * @sbmlfunction{formulaToL3String, ASTNode}.  The Level&nbsp;1-oriented
 * system (i.e., what is provided by @sbmlfunction{formulaToString, String}
 * and @sbmlfunction{parseFormula, ASTNode}) is provided
 * untouched for backwards compatibility.
 *
 *
 *
 *
 * @note We urge developers to keep in mind that the text-string formula
 * syntax is specific to libSBML.  <em>Neither MathML nor SBML define a
 * text-string format for mathematical formulas.</em> LibSBML's particular
 * syntax should not be considered to be a canonical or standard
 * general-purpose mathematical expression syntax.  LibSBML provides methods
 * for parsing and transforming text-string math formulas back and forth from
 * AST structures for the convenience of calling applications, but it is
 * important to keep the system's limitations in mind.
 *
 *
 *
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */ public
 static ASTNode parseFormula(string formula) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.parseFormula(formula);
    ASTNode ret = (cPtr == global::System.IntPtr.Zero) ? null : new ASTNode(cPtr, true);
    return ret;
  }

  
/**
 * Converts an AST to a text string representation of a formula using an
 * extended syntax.
 *
 *
 * 
 * The text-string form of mathematical formulas read by the function
 * @sbmlfunction{parseL3Formula, String} and written by the function
 * @sbmlfunction{formulaToL3String, ASTNode} uses an expanded version of
 * the syntax read and written by @sbmlfunction{parseFormula, String}
 * and @sbmlfunction{formulaToString, ASTNode}, respectively.  The
 * latter two libSBML functions were originally developed to support
 * conversion between SBML Levels&nbsp;1 and&nbsp;2, and were focused on the
 * syntax of mathematical formulas used in SBML Level&nbsp;1.  With time, and
 * the use of MathML in SBML Levels&nbsp;2 and&nbsp;3, it became clear that
 * supporting Level&nbsp;2 and&nbsp;3's expanded mathematical syntax would be
 * useful for software developers.  To maintain backwards compatibility for
 * libSBML users, the original @sbmlfunction{formulaToString, ASTNode}
 * and @sbmlfunction{parseFormula, String} have been left untouched,
 * and instead, the new functionality is provided in the form of
 * @sbmlfunction{parseL3Formula, String} and
 * @sbmlfunction{formulaToL3String, ASTNode}.
 *
 * The following lists the main differences in the formula syntax supported by
 * the Level 3 ('L3') versions of the formula parsers and formatters,
 * compared to what is supported by the Level&nbsp;1-oriented
 * @sbmlfunction{parseFormula, String} and
 * @sbmlfunction{formulaToString, ASTNode}:
 *
 * @li Units may be asociated with bare numbers, using the following syntax:
 * <div style='margin: 10px auto 10px 25px; display: block'>
 * <span class='code' style='background-color: #d0d0ee'>number</span>
 * <span class='code' style='background-color: #edd'>unit</span>
 * </div>
 * The <span class='code' style='background-color: #d0d0ee'>number</span>
 * may be in any form (an integer, real, or rational
 * number), and the
 * <span class='code' style='background-color: #edd'>unit</span>
 * must conform to the syntax of an SBML identifier (technically, the
 * type defined as @c SId in the SBML specifications).  The whitespace between
 * <span class='code' style='background-color: #d0d0ee'>number</span>
 * and <span class='code' style='background-color: #edd'>unit</span>
 * is optional.
 *
 * @li The Boolean function symbols @c && (@em and), @c || (@em or), @c ! (@em not),
 * and @c != (@em not @em equals) may be used.
 *
 * @li The @em modulo operation is allowed as the symbol @c @% and will
 * produce a <code>&lt;piecewise&gt;</code> function in the corresponding
 * MathML output by default, or can produce the MathML function @c rem, 
 * depending on the L3ParserSettings object (see 
 * L3ParserSettings_setParseModuloL3v2() ).
 *
 * @li All inverse trigonometric functions may be defined in the infix either
 * using @c arc as a prefix or simply @c a; in other words, both @c arccsc
 * and @c acsc are interpreted as the operator @em arccosecant as defined in
 * MathML&nbsp;2.0.  (Many functions in the simpler SBML Level&nbsp;1
 * oriented parser implemented by @sbmlfunction{parseFormula, String}
 * are defined this way as well, but not all.)
 *
 * @li The following expression is parsed as a rational number instead of
 * as a numerical division:
 * <pre style='display: block; margin-left: 25px'>
 * (<span class='code' style='background-color: #d0d0ee'>integer</span>/<span class='code' style='background-color: #d0d0ee'>integer</span>)</pre>
 * <strong>Spaces are not allowed</strong> in this construct; in other words,
 * &quot;<code>(3 / 4)</code>&quot; (with whitespace between the numbers and
 * the operator) will be parsed into the MathML <code>&lt;divide&gt;</code>
 * construct rather than a rational number.  You can, however, assign units to a
 * rational number as a whole; here is an example: &quot;<code>(3/4) ml</code>&quot;.
 * (In the case of division rather than a rational number, units are not interpreted
 * in this way.)
 *
 * @li Various parser and formatter behaviors may be altered through the use
 * of a L3ParserSettings object in conjunction with the functions
 * @sbmlfunction{parseL3FormulaWithSettings, String\, L3ParserSettings} and
 * @sbmlfunction{formulaToL3StringWithSettings, ASTNode\, L3ParserSettings}
 * The settings available include the following:
 * <ul style='list-style-type: circle'>
 *
 * <li style='margin-bottom: 0.5em'> The function @c log with a single
 * argument (&quot;<code>log(x)</code>&quot;) can be parsed as
 * <code>log10(x)</code>, <code>ln(x)</code>, or treated as an error, as
 * desired.
 *
 * <li style='margin-bottom: 0.5em'> Unary minus signs can be collapsed or
 * preserved; that is, sequential pairs of unary minuses (e.g., &quot;<code>-
 * -3</code>&quot;) can be removed from the input entirely and single unary
 * minuses can be incorporated into the number node, or all minuses can be
 * preserved in the AST node structure.
 *
 * <li style='margin-bottom: 0.5em'> Parsing of units embedded in the input
 * string can be turned on and off.
 *
 * <li style='margin-bottom: 0.5em'> The string @c avogadro can be parsed as
 * a MathML @em csymbol or as an identifier.
 *
 * <li style='margin-bottom: 0.5em'> The string @% can be parsed either as a 
 * piecewise function or as the 'rem' function:  <code>a @% b</code> will either
 * become
 *
 * <code>piecewise(a - b*ceil(a/b), xor((a < 0), (b < 0)), a - b*floor(a/b))</code>
 *
 * or 
 *
 * <code>rem(a, b)</code>.
 *
 * The latter is simpler, but the @c rem MathML is only allowed
 * as of SBML Level&nbsp;3 Version&nbsp;2.</li>
 *
 * <li style='margin-bottom: 0.5em'> A Model object may optionally be
 * provided to the parser using the variant function call
 * @sbmlfunction{parseL3FormulaWithModel, String\, Model} or
 * stored in a L3ParserSettings object passed to the variant function
 * @sbmlfunction{parseL3FormulaWithSettings, String\,
 * L3ParserSettings}.  When a Model object is provided, identifiers
 * (values of type @c SId ) from that model are used in preference to
 * pre-defined MathML definitions for both symbols and functions.
 * More precisely:
 * <ul style='list-style-type: square'>
 *
 * <li style='margin-bottom: 0.5em'> <em>In the case of symbols</em>: the
 * Model entities whose identifiers will shadow identical symbols in the
 * mathematical formula are: Species, Compartment, Parameter, Reaction, and
 * SpeciesReference.  For instance, if the parser is given a Model containing
 * a Species with the identifier &quot;<code>pi</code>&quot;, and the formula
 * to be parsed is &quot;<code>3*pi</code>&quot;, the MathML produced will
 * contain the construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of
 * the construct <code>&lt;pi/&gt;</code>.
 *
 * <li style='margin-bottom: 0.5em'> <em>In the case of user-defined
 * functions</em>: when a Model object is provided, @c SId values of
 * user-defined functions present in the model will be used preferentially
 * over pre-defined MathML functions.  For example, if the passed-in Model
 * contains a FunctionDefinition object with the identifier
 * &quot;<code>sin</code>&quot;, that function will be used instead of the
 * predefined MathML function <code>&lt;sin/&gt;</code>.
 * </ul>
 *
 * <li style='margin-bottom: 0.5em'> An SBMLNamespaces object may optionally
 * be provided to identify SBML Level&nbsp;3 packages that extend the
 * syntax understood by the formula parser.  When the namespaces are provided,
 * the parser will interpret possible additional syntax defined by the libSBML
 * plug-ins implementing the SBML Level&nbsp;3 packages; for example, it may
 * understand vector/array extensions introduced by the SBML Level&nbsp;3 @em
 * Arrays package.
 * </ul>
 *
 * These configuration settings cannot be changed directly using the basic
 * parser and formatter functions, but @em can be changed on a per-call basis
 * by using the alternative functions @sbmlfunction{parseL3FormulaWithSettings,
 * String\, L3ParserSettings} and
 * @sbmlfunction{formulaToL3StringWithSettings, ASTNode\,
 * L3ParserSettings}.
 *
 * Neither SBML nor the MathML standard define a 'string-form' equivalent to
 * MathML expressions.  The approach taken by libSBML is to start with the
 * formula syntax defined by SBML Level&nbsp;1 (which in fact used a custom
 * text-string representation of formulas, and not MathML), and expand it to
 * include the functionality described above.  This formula syntax is based
 * mostly on C programming syntax, and may contain operators, function calls,
 * symbols, and white space characters.  The following table provides the
 * precedence rules for the different entities that may appear in formula
 * strings.
 *
 * @htmlinclude math-precedence-table-l3.html
 *
 * In the table above, @em operand implies the construct is an operand, @em
 * prefix implies the operation is applied to the following arguments, @em
 * unary implies there is one argument, and @em binary implies there are
 * two arguments.  The values in the <b>Precedence</b> column show how the
 * order of different types of operation are determined.  For example, the
 * expression <code>a + b * c</code> is evaluated as <code>a + (b * c)</code>
 * because the @c * operator has higher precedence.  The
 * <b>Associates</b> column shows how the order of similar precedence
 * operations is determined; for example, <code>a && b || c</code> is
 * evaluated as <code>(a && b) || c</code> because the @c && and @c ||
 * operators are left-associative and have the same precedence.
 *
 * The function call syntax consists of a function name, followed by optional
 * white space, followed by an opening parenthesis token, followed by a
 * sequence of zero or more arguments separated by commas (with each comma
 * optionally preceded and/or followed by zero or more white space
 * characters), followed by a closing parenthesis token.  The function name
 * must be chosen from one of the pre-defined functions in SBML or a
 * user-defined function in the model.  The following table lists the names
 * of certain common mathematical functions; this table corresponds to
 * Table&nbsp;6 in the <a target='_blank'
 * href='http://sbml.org/Documents/Specifications#SBML_Level_1_Version_2'>SBML
 * Level&nbsp;1 Version&nbsp;2 specification</a> with additions based on the
 * functions added in SBML Level 2 and Level 3:
 *
 * @htmlinclude string-functions-table-l3.html
 *
 * Parsing of the various MathML functions and constants are all
 * case-insensitive by default: function names such as <code>cos</code>,
 * <code>Cos</code> and <code>COS</code> are all parsed as the MathML cosine
 * operator, <code>&lt;cos&gt;</code>.  However, <em>when a Model object is
 * used</em> in conjunction with either
 * @sbmlfunction{parseL3FormulaWithModel, String\, Model} or
 * @sbmlfunction{parseL3FormulaWithSettings, String\,
 * L3ParserSettings}, any identifiers found in that model will be
 * parsed in a case-<em>sensitive</em> way.  For example, if a model contains
 * a Species having the identifier <code>Pi</code>, the parser will parse
 * &quot;<code>Pi</code>&quot; in the input as &quot;<code>&lt;ci&gt; Pi
 * &lt;/ci&gt;</code>&quot; but will continue to parse the symbols
 * &quot;<code>pi</code>&quot; and &quot;<code>PI</code>&quot; as
 * &quot;<code>&lt;pi&gt;</code>&quot;.
 *
 * As mentioned above, the manner in which the 'L3' versions of the formula
 * parser and formatter interpret the function &quot;<code>log</code>&quot;
 * can be changed.  To do so, callers should use the function
 * @sbmlfunction{parseL3FormulaWithSettings, String\,
 * L3ParserSettings} and pass it an appropriate L3ParserSettings
 * object.  By default, unlike the SBML Level&nbsp;1 parser implemented by
 * @sbmlfunction{parseFormula, String}, the string
 * &quot;<code>log</code>&quot; is interpreted as the base&nbsp;10 logarithm,
 * and @em not as the natural logarithm.  However, you can change the
 * interpretation to be base-10 log, natural log, or as an error; since the
 * name 'log' by itself is ambiguous, you require that the parser uses
 * @c log10 or @c ln instead, which are more clear.  Please refer to
 * @sbmlfunction{parseL3FormulaWithSettings, String\,
 * L3ParserSettings}.
 *
 * In addition, the following symbols will be translated to their MathML
 * equivalents, if no symbol with the same @c SId identifier string exists
 * in the Model object provided:
 *
 * @htmlinclude string-values-table-l3.html
 *
 * Again, as mentioned above, whether the string
 * &quot;<code>avogadro</code>&quot; is parsed as an AST node of type
 * @link libsbml#AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink or
 * @link libsbml#AST_NAME AST_NAME@endlink is configurable; use the version of
 * the parser function called @sbmlfunction{parseL3FormulaWithSettings,
 * String\, L3ParserSettings}.  This Avogadro-related
 * functionality is provided because SBML Level&nbsp;2 models may not use
 * @link libsbml#AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink AST nodes.
 *
 *
 *
 * @param tree the AST to be converted.
 *
 * @return the formula from the given AST as text string, with a syntax
 * oriented towards the capabilities defined in SBML Level&nbsp;3.  The
 * caller owns the returned string and is responsible for freeing it when it
 * is no longer needed.  If @p tree is a null pointer, then a null pointer is
 * returned.
 *
 * @see @sbmlfunction{formulaToL3StringWithSettings, ASTNode\, L3ParserSettings}
 * @see @sbmlfunction{formulaToString, ASTNode}
 * @see @sbmlfunction{parseL3FormulaWithSettings, String\, L3ParserSettings}
 * @see @sbmlfunction{parseL3FormulaWithModel, String\, Model}
 * @see @sbmlfunction{parseFormula, String}
 * @see L3ParserSettings
 * @see @sbmlfunction{getDefaultL3ParserSettings,}
 * @see @sbmlfunction{getLastParseL3Error,}
 *
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */ public
 static string formulaToL3String(ASTNode tree) {
    string ret = libsbmlPINVOKE.formulaToL3String(ASTNode.getCPtr(tree));
    return ret;
  }

  
/**
 * Converts an AST to a text string representation of a formula, using
 * specific formatter settings.
 *
 * This function behaves identically to @sbmlfunction{formulaToL3String,
 * ASTNode} but its behavior is controlled by two fields in the @p
 * settings object, namely:
 *
 * @li <em>parseunits</em> ('parse units'): If this field in the @p settings
 *     object is set to <code>true</code> (the default), the function will
 *     write out the units of any numerical ASTNodes that have them,
 *     producing (for example) &quot;<code>3 mL</code>&quot;,
 *     &quot;<code>(3/4) m</code>&quot;, or &quot;<code>5.5e-10
 *     M</code>&quot;.  If this is set to <code>false</code>, this function
 *     will only write out the number itself (&quot;<code>3</code>&quot;,
 *     &quot;<code>(3/4)</code>&quot;, and &quot;<code>5.5e-10</code>&quot;,
 *     in the previous examples).
 * @li <em>collapseminus</em> ('collapse minus'): If this field in the @p
 *     settings object is set to <code>false</code> (the default), the
 *     function will write out explicitly any doubly-nested unary minus
 *     ASTNodes, producing (for example) &quot;<code>- -x</code>&quot; or
 *     even &quot;<code>- - - - -3.1</code>&quot;.  If this is set to
 *     <code>true</code>, the function will collapse the nodes before
 *     producing the infix form, producing &quot;<code>x</code>&quot; and
 *     &quot;<code>-3.1</code>&quot; in the previous examples.
 *
 * All the other settings of the L3ParserSettings object passed in as @p
 * settings will be ignored for the purposes of this function: the
 * <em>parselog</em> ('parse log') setting is ignored so that
 * &quot;<code>log10(x)</code>&quot;, &quot;<code>ln(x)</code>&quot;, and
 * &quot;<code>log(x, y)</code>&quot; are always produced; the
 * <em>avocsymbol</em> ('Avogadro csymbol') is irrelevant to the behavior
 * of this function; and nothing in the Model object set via the
 * <em>model</em> setting is used.
 *
 * @param tree the AST to be converted.

 * @param settings the L3ParserSettings object used to modify the behavior of
 * this function.
 *
 * @return the formula from the given AST as text string, with a syntax
 * oriented towards the capabilities defined in SBML Level&nbsp;3.  The
 * caller owns the returned string and is responsible for freeing it when it
 * is no longer needed.  If @p tree is a null pointer, then a null pointer is
 * returned.
 *
 * @see @sbmlfunction{formulaToL3String, ASTNode}
 * @see @sbmlfunction{formulaToString, ASTNode}
 * @see @sbmlfunction{parseL3FormulaWithSettings, String\, L3ParserSettings}
 * @see @sbmlfunction{parseL3FormulaWithModel, String\, Model}
 * @see @sbmlfunction{parseFormula, String}
 * @see L3ParserSettings
 * @see @sbmlfunction{getDefaultL3ParserSettings,}
 * @see @sbmlfunction{getLastParseL3Error,}
 *
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */ public
 static string formulaToL3StringWithSettings(ASTNode tree, L3ParserSettings settings) {
    string ret = libsbmlPINVOKE.formulaToL3StringWithSettings(ASTNode.getCPtr(tree), L3ParserSettings.getCPtr(settings));
    return ret;
  }

  
/**
 * Converts an AST to a text string representation of a formula using a
 * basic syntax derived from SBML Level&nbsp;1.
 *
 *
 * 
 * The text-string form of mathematical formulas produced by
 * @sbmlfunction{formulaToString, ASTNode} and read by
 * @sbmlfunction{parseFormula, String} use a simple C-inspired infix
 * notation taken from SBML Level&nbsp;1.  A formula in this text-string form
 * therefore can be handed to a program that understands SBML Level&nbsp;1
 * mathematical expressions, or used as part of a formula translation system.
 * The syntax is described in detail in the documentation for ASTNode.  The
 * following are illustrative examples of formulas expressed using this syntax:
 * @verbatim
0.10 * k4^2
@endverbatim
@verbatim
(vm * s1)/(km + s1)
@endverbatim
 *
 * Note that this facility is provided as a convenience by libSBML---the
 * MathML standard does not actually define a 'string-form' equivalent to
 * MathML expression trees, so the choice of formula syntax is somewhat
 * arbitrary.  The approach taken by libSBML is to use the syntax defined by
 * SBML Level&nbsp;1 (which in fact used a text-string representation of
 * formulas and not MathML).  This formula syntax is based mostly on C
 * programming syntax, and may contain operators, function calls, symbols,
 * and white space characters.  The following table provides the precedence
 * rules for the different entities that may appear in formula strings.
 *
 * @htmlinclude math-precedence-table.html
 *
 * In the table above, @em operand implies the construct is an operand, @em
 * prefix implies the operation is applied to the following arguments, @em
 * unary implies there is one argument, and @em binary implies there are
 * two arguments.  The values in the <b>Precedence</b> column show how the
 * order of different types of operation are determined.  For example, the
 * expression <code>a * b + c</code> is evaluated as <code>(a * b) +
 * c</code> because the @c * operator has higher precedence.  The
 * <b>Associates</b> column shows how the order of similar precedence
 * operations is determined; for example, <code>a - b + c</code> is
 * evaluated as <code>(a - b) + c</code> because the @c + and @c -
 * operators are left-associative.
 *
 * The function call syntax consists of a function name, followed by optional
 * white space, followed by an opening parenthesis token, followed by a
 * sequence of zero or more arguments separated by commas (with each comma
 * optionally preceded and/or followed by zero or more white space
 * characters, followed by a closing parenthesis token.  The function name
 * must be chosen from one of the pre-defined functions in SBML or a
 * user-defined function in the model.  The following table lists the names
 * of certain common mathematical functions; this table corresponds to
 * Table&nbsp;6 in the <a target='_blank' href='http://sbml.org/Documents/Specifications#SBML_Level_1_Version_2'>SBML Level&nbsp;1 Version&nbsp;2 specification</a>:
 *
 * @htmlinclude string-functions-table.html
 *
 * @warning <span class='warning'>There are differences between the symbols
 * used to represent the common mathematical functions and the corresponding
 * MathML token names.  This is a potential source of incompatibilities.
 * Note in particular that in this text-string syntax, <code>log(x)</code>
 * represents the natural logarithm, whereas in MathML, the natural logarithm
 * is <code>&lt;ln/&gt;</code>.  Application writers are urged to be careful
 * when translating between text forms and MathML forms, especially if they
 * provide a direct text-string input facility to users of their software
 * systems.</span>
 *
 *
 *
 * @param tree the AST to be converted.
 *
 * @return the formula from the given AST as a text-string mathematical
 * formula oriented towards SBML Level&nbsp;1.  The caller owns the returned
 * string and is responsible for freeing it when it is no longer needed.
 *
 * @see @sbmlfunction{formulaToL3String, ASTNode}
 * @see @sbmlfunction{formulaToL3StringWithSettings, ASTNode\, L3ParserSettings}
 * @see @sbmlfunction{parseL3FormulaWithSettings, String\, L3ParserSettings}
 * @see @sbmlfunction{parseL3FormulaWithModel, String\, Model}
 * @see @sbmlfunction{parseFormula, String}
 *
 *
 * @note
 * Callers using SBML Level&nbsp;3 are encouraged to use the facilities
 * provided by libSBML's newer and more powerful Level&nbsp;3-oriented
 * formula parser and formatter.  The entry points to this second system are
 * @sbmlfunction{parseL3Formula, String} and
 * @sbmlfunction{formulaToL3String, ASTNode}.  The Level&nbsp;1-oriented
 * system (i.e., what is provided by @sbmlfunction{formulaToString, String}
 * and @sbmlfunction{parseFormula, ASTNode}) is provided
 * untouched for backwards compatibility.
 *
 *
 *
 *
 * @note We urge developers to keep in mind that the text-string formula
 * syntax is specific to libSBML.  <em>Neither MathML nor SBML define a
 * text-string format for mathematical formulas.</em> LibSBML's particular
 * syntax should not be considered to be a canonical or standard
 * general-purpose mathematical expression syntax.  LibSBML provides methods
 * for parsing and transforming text-string math formulas back and forth from
 * AST structures for the convenience of calling applications, but it is
 * important to keep the system's limitations in mind.
 *
 *
 *
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */ public
 static string formulaToString(ASTNode tree) {
    string ret = libsbmlPINVOKE.formulaToString(ASTNode.getCPtr(tree));
    return ret;
  }

  
/**
 * Parses a text string as a mathematical formula and returns an AST
 * representation of it.
 *
 *
 * 
 * The text-string form of mathematical formulas read by the function
 * @sbmlfunction{parseL3Formula, String} and written by the function
 * @sbmlfunction{formulaToL3String, ASTNode} uses an expanded version of
 * the syntax read and written by @sbmlfunction{parseFormula, String}
 * and @sbmlfunction{formulaToString, ASTNode}, respectively.  The
 * latter two libSBML functions were originally developed to support
 * conversion between SBML Levels&nbsp;1 and&nbsp;2, and were focused on the
 * syntax of mathematical formulas used in SBML Level&nbsp;1.  With time, and
 * the use of MathML in SBML Levels&nbsp;2 and&nbsp;3, it became clear that
 * supporting Level&nbsp;2 and&nbsp;3's expanded mathematical syntax would be
 * useful for software developers.  To maintain backwards compatibility for
 * libSBML users, the original @sbmlfunction{formulaToString, ASTNode}
 * and @sbmlfunction{parseFormula, String} have been left untouched,
 * and instead, the new functionality is provided in the form of
 * @sbmlfunction{parseL3Formula, String} and
 * @sbmlfunction{formulaToL3String, ASTNode}.
 *
 * The following lists the main differences in the formula syntax supported by
 * the Level 3 ('L3') versions of the formula parsers and formatters,
 * compared to what is supported by the Level&nbsp;1-oriented
 * @sbmlfunction{parseFormula, String} and
 * @sbmlfunction{formulaToString, ASTNode}:
 *
 * @li Units may be asociated with bare numbers, using the following syntax:
 * <div style='margin: 10px auto 10px 25px; display: block'>
 * <span class='code' style='background-color: #d0d0ee'>number</span>
 * <span class='code' style='background-color: #edd'>unit</span>
 * </div>
 * The <span class='code' style='background-color: #d0d0ee'>number</span>
 * may be in any form (an integer, real, or rational
 * number), and the
 * <span class='code' style='background-color: #edd'>unit</span>
 * must conform to the syntax of an SBML identifier (technically, the
 * type defined as @c SId in the SBML specifications).  The whitespace between
 * <span class='code' style='background-color: #d0d0ee'>number</span>
 * and <span class='code' style='background-color: #edd'>unit</span>
 * is optional.
 *
 * @li The Boolean function symbols @c && (@em and), @c || (@em or), @c ! (@em not),
 * and @c != (@em not @em equals) may be used.
 *
 * @li The @em modulo operation is allowed as the symbol @c @% and will
 * produce a <code>&lt;piecewise&gt;</code> function in the corresponding
 * MathML output by default, or can produce the MathML function @c rem, 
 * depending on the L3ParserSettings object (see 
 * L3ParserSettings_setParseModuloL3v2() ).
 *
 * @li All inverse trigonometric functions may be defined in the infix either
 * using @c arc as a prefix or simply @c a; in other words, both @c arccsc
 * and @c acsc are interpreted as the operator @em arccosecant as defined in
 * MathML&nbsp;2.0.  (Many functions in the simpler SBML Level&nbsp;1
 * oriented parser implemented by @sbmlfunction{parseFormula, String}
 * are defined this way as well, but not all.)
 *
 * @li The following expression is parsed as a rational number instead of
 * as a numerical division:
 * <pre style='display: block; margin-left: 25px'>
 * (<span class='code' style='background-color: #d0d0ee'>integer</span>/<span class='code' style='background-color: #d0d0ee'>integer</span>)</pre>
 * <strong>Spaces are not allowed</strong> in this construct; in other words,
 * &quot;<code>(3 / 4)</code>&quot; (with whitespace between the numbers and
 * the operator) will be parsed into the MathML <code>&lt;divide&gt;</code>
 * construct rather than a rational number.  You can, however, assign units to a
 * rational number as a whole; here is an example: &quot;<code>(3/4) ml</code>&quot;.
 * (In the case of division rather than a rational number, units are not interpreted
 * in this way.)
 *
 * @li Various parser and formatter behaviors may be altered through the use
 * of a L3ParserSettings object in conjunction with the functions
 * @sbmlfunction{parseL3FormulaWithSettings, String\, L3ParserSettings} and
 * @sbmlfunction{formulaToL3StringWithSettings, ASTNode\, L3ParserSettings}
 * The settings available include the following:
 * <ul style='list-style-type: circle'>
 *
 * <li style='margin-bottom: 0.5em'> The function @c log with a single
 * argument (&quot;<code>log(x)</code>&quot;) can be parsed as
 * <code>log10(x)</code>, <code>ln(x)</code>, or treated as an error, as
 * desired.
 *
 * <li style='margin-bottom: 0.5em'> Unary minus signs can be collapsed or
 * preserved; that is, sequential pairs of unary minuses (e.g., &quot;<code>-
 * -3</code>&quot;) can be removed from the input entirely and single unary
 * minuses can be incorporated into the number node, or all minuses can be
 * preserved in the AST node structure.
 *
 * <li style='margin-bottom: 0.5em'> Parsing of units embedded in the input
 * string can be turned on and off.
 *
 * <li style='margin-bottom: 0.5em'> The string @c avogadro can be parsed as
 * a MathML @em csymbol or as an identifier.
 *
 * <li style='margin-bottom: 0.5em'> The string @% can be parsed either as a 
 * piecewise function or as the 'rem' function:  <code>a @% b</code> will either
 * become
 *
 * <code>piecewise(a - b*ceil(a/b), xor((a < 0), (b < 0)), a - b*floor(a/b))</code>
 *
 * or 
 *
 * <code>rem(a, b)</code>.
 *
 * The latter is simpler, but the @c rem MathML is only allowed
 * as of SBML Level&nbsp;3 Version&nbsp;2.</li>
 *
 * <li style='margin-bottom: 0.5em'> A Model object may optionally be
 * provided to the parser using the variant function call
 * @sbmlfunction{parseL3FormulaWithModel, String\, Model} or
 * stored in a L3ParserSettings object passed to the variant function
 * @sbmlfunction{parseL3FormulaWithSettings, String\,
 * L3ParserSettings}.  When a Model object is provided, identifiers
 * (values of type @c SId ) from that model are used in preference to
 * pre-defined MathML definitions for both symbols and functions.
 * More precisely:
 * <ul style='list-style-type: square'>
 *
 * <li style='margin-bottom: 0.5em'> <em>In the case of symbols</em>: the
 * Model entities whose identifiers will shadow identical symbols in the
 * mathematical formula are: Species, Compartment, Parameter, Reaction, and
 * SpeciesReference.  For instance, if the parser is given a Model containing
 * a Species with the identifier &quot;<code>pi</code>&quot;, and the formula
 * to be parsed is &quot;<code>3*pi</code>&quot;, the MathML produced will
 * contain the construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of
 * the construct <code>&lt;pi/&gt;</code>.
 *
 * <li style='margin-bottom: 0.5em'> <em>In the case of user-defined
 * functions</em>: when a Model object is provided, @c SId values of
 * user-defined functions present in the model will be used preferentially
 * over pre-defined MathML functions.  For example, if the passed-in Model
 * contains a FunctionDefinition object with the identifier
 * &quot;<code>sin</code>&quot;, that function will be used instead of the
 * predefined MathML function <code>&lt;sin/&gt;</code>.
 * </ul>
 *
 * <li style='margin-bottom: 0.5em'> An SBMLNamespaces object may optionally
 * be provided to identify SBML Level&nbsp;3 packages that extend the
 * syntax understood by the formula parser.  When the namespaces are provided,
 * the parser will interpret possible additional syntax defined by the libSBML
 * plug-ins implementing the SBML Level&nbsp;3 packages; for example, it may
 * understand vector/array extensions introduced by the SBML Level&nbsp;3 @em
 * Arrays package.
 * </ul>
 *
 * These configuration settings cannot be changed directly using the basic
 * parser and formatter functions, but @em can be changed on a per-call basis
 * by using the alternative functions @sbmlfunction{parseL3FormulaWithSettings,
 * String\, L3ParserSettings} and
 * @sbmlfunction{formulaToL3StringWithSettings, ASTNode\,
 * L3ParserSettings}.
 *
 * Neither SBML nor the MathML standard define a 'string-form' equivalent to
 * MathML expressions.  The approach taken by libSBML is to start with the
 * formula syntax defined by SBML Level&nbsp;1 (which in fact used a custom
 * text-string representation of formulas, and not MathML), and expand it to
 * include the functionality described above.  This formula syntax is based
 * mostly on C programming syntax, and may contain operators, function calls,
 * symbols, and white space characters.  The following table provides the
 * precedence rules for the different entities that may appear in formula
 * strings.
 *
 * @htmlinclude math-precedence-table-l3.html
 *
 * In the table above, @em operand implies the construct is an operand, @em
 * prefix implies the operation is applied to the following arguments, @em
 * unary implies there is one argument, and @em binary implies there are
 * two arguments.  The values in the <b>Precedence</b> column show how the
 * order of different types of operation are determined.  For example, the
 * expression <code>a + b * c</code> is evaluated as <code>a + (b * c)</code>
 * because the @c * operator has higher precedence.  The
 * <b>Associates</b> column shows how the order of similar precedence
 * operations is determined; for example, <code>a && b || c</code> is
 * evaluated as <code>(a && b) || c</code> because the @c && and @c ||
 * operators are left-associative and have the same precedence.
 *
 * The function call syntax consists of a function name, followed by optional
 * white space, followed by an opening parenthesis token, followed by a
 * sequence of zero or more arguments separated by commas (with each comma
 * optionally preceded and/or followed by zero or more white space
 * characters), followed by a closing parenthesis token.  The function name
 * must be chosen from one of the pre-defined functions in SBML or a
 * user-defined function in the model.  The following table lists the names
 * of certain common mathematical functions; this table corresponds to
 * Table&nbsp;6 in the <a target='_blank'
 * href='http://sbml.org/Documents/Specifications#SBML_Level_1_Version_2'>SBML
 * Level&nbsp;1 Version&nbsp;2 specification</a> with additions based on the
 * functions added in SBML Level 2 and Level 3:
 *
 * @htmlinclude string-functions-table-l3.html
 *
 * Parsing of the various MathML functions and constants are all
 * case-insensitive by default: function names such as <code>cos</code>,
 * <code>Cos</code> and <code>COS</code> are all parsed as the MathML cosine
 * operator, <code>&lt;cos&gt;</code>.  However, <em>when a Model object is
 * used</em> in conjunction with either
 * @sbmlfunction{parseL3FormulaWithModel, String\, Model} or
 * @sbmlfunction{parseL3FormulaWithSettings, String\,
 * L3ParserSettings}, any identifiers found in that model will be
 * parsed in a case-<em>sensitive</em> way.  For example, if a model contains
 * a Species having the identifier <code>Pi</code>, the parser will parse
 * &quot;<code>Pi</code>&quot; in the input as &quot;<code>&lt;ci&gt; Pi
 * &lt;/ci&gt;</code>&quot; but will continue to parse the symbols
 * &quot;<code>pi</code>&quot; and &quot;<code>PI</code>&quot; as
 * &quot;<code>&lt;pi&gt;</code>&quot;.
 *
 * As mentioned above, the manner in which the 'L3' versions of the formula
 * parser and formatter interpret the function &quot;<code>log</code>&quot;
 * can be changed.  To do so, callers should use the function
 * @sbmlfunction{parseL3FormulaWithSettings, String\,
 * L3ParserSettings} and pass it an appropriate L3ParserSettings
 * object.  By default, unlike the SBML Level&nbsp;1 parser implemented by
 * @sbmlfunction{parseFormula, String}, the string
 * &quot;<code>log</code>&quot; is interpreted as the base&nbsp;10 logarithm,
 * and @em not as the natural logarithm.  However, you can change the
 * interpretation to be base-10 log, natural log, or as an error; since the
 * name 'log' by itself is ambiguous, you require that the parser uses
 * @c log10 or @c ln instead, which are more clear.  Please refer to
 * @sbmlfunction{parseL3FormulaWithSettings, String\,
 * L3ParserSettings}.
 *
 * In addition, the following symbols will be translated to their MathML
 * equivalents, if no symbol with the same @c SId identifier string exists
 * in the Model object provided:
 *
 * @htmlinclude string-values-table-l3.html
 *
 * Again, as mentioned above, whether the string
 * &quot;<code>avogadro</code>&quot; is parsed as an AST node of type
 * @link libsbml#AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink or
 * @link libsbml#AST_NAME AST_NAME@endlink is configurable; use the version of
 * the parser function called @sbmlfunction{parseL3FormulaWithSettings,
 * String\, L3ParserSettings}.  This Avogadro-related
 * functionality is provided because SBML Level&nbsp;2 models may not use
 * @link libsbml#AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink AST nodes.
 *
 *
 *
 * @param formula the text-string formula expression to be parsed.
 *
 * @return the root node of an AST representing the mathematical formula, or
 * @c null if an error occurred while parsing the formula.  When @c null is
 * returned, an error is recorded internally; information about the error can
 * be retrieved using @sbmlfunction{getLastParseL3Error,}.
 *
 * @see @sbmlfunction{parseL3FormulaWithSettings, String\, L3ParserSettings}
 * @see @sbmlfunction{parseL3FormulaWithModel, String\, Model}
 * @see @sbmlfunction{parseFormula, String}
 * @see @sbmlfunction{formulaToL3StringWithSettings, ASTNode\, L3ParserSettings}
 * @see @sbmlfunction{formulaToL3String, ASTNode}
 * @see @sbmlfunction{formulaToString, ASTNode}
 * @see L3ParserSettings
 * @see @sbmlfunction{getDefaultL3ParserSettings,}
 * @see @sbmlfunction{getLastParseL3Error,}
 *
 *
 * @note We urge developers to keep in mind that the text-string formula
 * syntax is specific to libSBML.  <em>Neither MathML nor SBML define a
 * text-string format for mathematical formulas.</em> LibSBML's particular
 * syntax should not be considered to be a canonical or standard
 * general-purpose mathematical expression syntax.  LibSBML provides methods
 * for parsing and transforming text-string math formulas back and forth from
 * AST structures for the convenience of calling applications, but it is
 * important to keep the system's limitations in mind.
 *
 *
 *
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */ public
 static ASTNode parseL3Formula(string formula) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.parseL3Formula(formula);
    ASTNode ret = (cPtr == global::System.IntPtr.Zero) ? null : new ASTNode(cPtr, true);
    return ret;
  }

  
/**
 * Parses a text string as a mathematical formula using a Model to resolve
 * symbols, and returns an AST representation of the result.
 *
 * This is identical to @sbmlfunction{parseL3Formula, String}, except
 * that this function uses the given model in the argument @p model to check
 * against identifiers that appear in the @p formula.  For more information
 * about the parser, please see the definition of L3ParserSettings and
 * the function @sbmlfunction{parseL3Formula, String}.
 *
 * @param formula the mathematical formula expression to be parsed.
 *
 * @param model the Model object to use for checking identifiers.
 *
 * @return the root node of an AST representing the mathematical formula,
 * or @c null if an error occurred while parsing the formula.  When @c null
 * is returned, an error is recorded internally; information about the
 * error can be retrieved using @sbmlfunction{getLastParseL3Error,}.
 *
 * @see @sbmlfunction{parseL3Formula, String}
 * @see @sbmlfunction{parseL3FormulaWithSettings, String\, L3ParserSettings}
 * @see @sbmlfunction{parseL3FormulaWithModel, String\, Model}
 * @see @sbmlfunction{parseFormula, String}
 * @see @sbmlfunction{getLastParseL3Error,}
 * @see L3ParserSettings
 *
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */ public
 static ASTNode parseL3FormulaWithModel(string formula, Model model) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.parseL3FormulaWithModel(formula, Model.getCPtr(model));
    ASTNode ret = (cPtr == global::System.IntPtr.Zero) ? null : new ASTNode(cPtr, true);
    return ret;
  }

  
/**
 * Parses a text string as a mathematical formula using specific parser
 * settings and returns an AST representation of the result.
 *
 * This is identical to @sbmlfunction{parseL3Formula, String}, except
 * that this function uses the parser settings given in the argument @p
 * settings.  The settings override the default parsing behavior.  The
 * following parsing behaviors can be configured:
 * @li A Model object may optionally be provided to use identifiers (values
 * of type @c SId) from the model in preference to pre-defined MathML symbols
 * More precisely, the Model entities whose identifiers will shadow identical
 * symbols in the mathematical formula are: Species, Compartment, Parameter,
 * Reaction, and SpeciesReference.  For instance, if the parser is given a
 * Model containing a Species with the identifier
 * &quot;<code>pi</code>&quot;, and the formula to be parsed is
 * &quot;<code>3*pi</code>&quot;, the MathML produced by the parser will
 * contain the construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of
 * the construct <code>&lt;pi/&gt;</code>.  Another example, if the passed-in
 * Model contains a FunctionDefinition with the identifier
 * &quot;<code>sin</code>&quot;, that function will be used instead of the
 * predefined MathML function <code>&lt;sin/&gt;</code>.
 * @li The function @c log with a single argument
 * (&quot;<code>log(x)</code>&quot;) can be parsed as <code>log10(x)</code>,
 * <code>ln(x)</code>, or treated as an error, as desired.
 * @li Unary minus signs can be either collapsed or preserved; that is, the
 * parser can either (1) remove sequential pairs of unary minuses (e.g.,
 * &quot;<code>- -3</code>&quot;) from the input and incorporate single unary
 * minuses into the number node, or (2) preserve all minuses in the AST node
 * structure, turning them into ASTNode objects of type
 * @link libsbml#AST_MINUS AST_MINUS@endlink.
 * @li The character sequence &quot;<code>number id</code>&quot; can be
 * interpreted as a numerical value @c number followed by units of measurement
 * indicated by @c id, or it can be treated as a syntax error.  (In
 * Level&nbsp;3, MathML <code>&lt;cn&gt;</code> elements can have an
 * attribute named @c units placed in the SBML namespace, which can be used
 * to indicate the units to be associated with the number.  The text-string
 * infix formula parser allows units to be placed after raw numbers; they are
 * interpreted as unit identifiers for units defined by the SBML
 * specification or in the containing Model object.)
 * @li The symbol @c avogadro can be parsed either as a MathML @em csymbol or
 * as a identifier.  More specifically, &quot;<code>avogadro</code>&quot; can
 * be treated as an ASTNode of type
 * @link libsbml#AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink or of type
 * @link libsbml#AST_NAME AST_NAME@endlink.
 * @li Strings that match built-in functions and constants can either be parsed
 * as a match regardless of capitalization, or may be required to be
 * all-lower-case to be considered a match.
 * @li LibSBML plug-ins implementing support for SBML Level&nbsp;3 packages
 * may introduce extensions to the syntax understood by the parser.  The
 * precise nature of the extensions will be documented by the individual
 * package plug-ins.  An example of a possible extension is a notation for
 * vectors and arrays, introduced by the SBML Level&nbsp;3 @em Arrays
 * package.
 *
 *
 *
 * For more details about the parser, please see the definition of
 * L3ParserSettings and @sbmlfunction{parseL3FormulaWithSettings, String\,
 * L3ParserSettings}.
 *
 * @param formula the mathematical formula expression to be parsed.
 *
 * @param settings the settings to be used for this parser invocation.
 *
 * @return the root node of an AST representing the mathematical formula,
 * or @c null if an error occurred while parsing the formula.  When @c null
 * is returned, an error is recorded internally; information about the
 * error can be retrieved using @sbmlfunction{getLastParseL3Error,}.
 *
 * @see @sbmlfunction{parseL3Formula, String}
 * @see @sbmlfunction{parseL3FormulaWithSettings, String\, L3ParserSettings}
 * @see @sbmlfunction{parseL3FormulaWithModel, String\, Model}
 * @see @sbmlfunction{parseFormula, String}
 * @see @sbmlfunction{getLastParseL3Error,}
 * @see L3ParserSettings
 *
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */ public
 static ASTNode parseL3FormulaWithSettings(string formula, L3ParserSettings settings) {
    global::System.IntPtr cPtr = libsbmlPINVOKE.parseL3FormulaWithSettings(formula, L3ParserSettings.getCPtr(settings));
    ASTNode ret = (cPtr == global::System.IntPtr.Zero) ? null : new ASTNode(cPtr, true);
    return ret;
  }

  
/**
 * Returns a copy of the default Level&nbsp;3 ('L3') formula parser settings.
 *
 * The data structure storing the settings allows callers to change the
 * following parsing behaviors:
 *
 *
 * 
 * The text-string form of mathematical formulas read by the function
 * @sbmlfunction{parseL3Formula, String} and written by the function
 * @sbmlfunction{formulaToL3String, ASTNode} uses an expanded version of
 * the syntax read and written by @sbmlfunction{parseFormula, String}
 * and @sbmlfunction{formulaToString, ASTNode}, respectively.  The
 * latter two libSBML functions were originally developed to support
 * conversion between SBML Levels&nbsp;1 and&nbsp;2, and were focused on the
 * syntax of mathematical formulas used in SBML Level&nbsp;1.  With time, and
 * the use of MathML in SBML Levels&nbsp;2 and&nbsp;3, it became clear that
 * supporting Level&nbsp;2 and&nbsp;3's expanded mathematical syntax would be
 * useful for software developers.  To maintain backwards compatibility for
 * libSBML users, the original @sbmlfunction{formulaToString, ASTNode}
 * and @sbmlfunction{parseFormula, String} have been left untouched,
 * and instead, the new functionality is provided in the form of
 * @sbmlfunction{parseL3Formula, String} and
 * @sbmlfunction{formulaToL3String, ASTNode}.
 *
 * The following lists the main differences in the formula syntax supported by
 * the Level 3 ('L3') versions of the formula parsers and formatters,
 * compared to what is supported by the Level&nbsp;1-oriented
 * @sbmlfunction{parseFormula, String} and
 * @sbmlfunction{formulaToString, ASTNode}:
 *
 * @li Units may be asociated with bare numbers, using the following syntax:
 * <div style='margin: 10px auto 10px 25px; display: block'>
 * <span class='code' style='background-color: #d0d0ee'>number</span>
 * <span class='code' style='background-color: #edd'>unit</span>
 * </div>
 * The <span class='code' style='background-color: #d0d0ee'>number</span>
 * may be in any form (an integer, real, or rational
 * number), and the
 * <span class='code' style='background-color: #edd'>unit</span>
 * must conform to the syntax of an SBML identifier (technically, the
 * type defined as @c SId in the SBML specifications).  The whitespace between
 * <span class='code' style='background-color: #d0d0ee'>number</span>
 * and <span class='code' style='background-color: #edd'>unit</span>
 * is optional.
 *
 * @li The Boolean function symbols @c && (@em and), @c || (@em or), @c ! (@em not),
 * and @c != (@em not @em equals) may be used.
 *
 * @li The @em modulo operation is allowed as the symbol @c @% and will
 * produce a <code>&lt;piecewise&gt;</code> function in the corresponding
 * MathML output by default, or can produce the MathML function @c rem, 
 * depending on the L3ParserSettings object (see 
 * L3ParserSettings_setParseModuloL3v2() ).
 *
 * @li All inverse trigonometric functions may be defined in the infix either
 * using @c arc as a prefix or simply @c a; in other words, both @c arccsc
 * and @c acsc are interpreted as the operator @em arccosecant as defined in
 * MathML&nbsp;2.0.  (Many functions in the simpler SBML Level&nbsp;1
 * oriented parser implemented by @sbmlfunction{parseFormula, String}
 * are defined this way as well, but not all.)
 *
 * @li The following expression is parsed as a rational number instead of
 * as a numerical division:
 * <pre style='display: block; margin-left: 25px'>
 * (<span class='code' style='background-color: #d0d0ee'>integer</span>/<span class='code' style='background-color: #d0d0ee'>integer</span>)</pre>
 * <strong>Spaces are not allowed</strong> in this construct; in other words,
 * &quot;<code>(3 / 4)</code>&quot; (with whitespace between the numbers and
 * the operator) will be parsed into the MathML <code>&lt;divide&gt;</code>
 * construct rather than a rational number.  You can, however, assign units to a
 * rational number as a whole; here is an example: &quot;<code>(3/4) ml</code>&quot;.
 * (In the case of division rather than a rational number, units are not interpreted
 * in this way.)
 *
 * @li Various parser and formatter behaviors may be altered through the use
 * of a L3ParserSettings object in conjunction with the functions
 * @sbmlfunction{parseL3FormulaWithSettings, String\, L3ParserSettings} and
 * @sbmlfunction{formulaToL3StringWithSettings, ASTNode\, L3ParserSettings}
 * The settings available include the following:
 * <ul style='list-style-type: circle'>
 *
 * <li style='margin-bottom: 0.5em'> The function @c log with a single
 * argument (&quot;<code>log(x)</code>&quot;) can be parsed as
 * <code>log10(x)</code>, <code>ln(x)</code>, or treated as an error, as
 * desired.
 *
 * <li style='margin-bottom: 0.5em'> Unary minus signs can be collapsed or
 * preserved; that is, sequential pairs of unary minuses (e.g., &quot;<code>-
 * -3</code>&quot;) can be removed from the input entirely and single unary
 * minuses can be incorporated into the number node, or all minuses can be
 * preserved in the AST node structure.
 *
 * <li style='margin-bottom: 0.5em'> Parsing of units embedded in the input
 * string can be turned on and off.
 *
 * <li style='margin-bottom: 0.5em'> The string @c avogadro can be parsed as
 * a MathML @em csymbol or as an identifier.
 *
 * <li style='margin-bottom: 0.5em'> The string @% can be parsed either as a 
 * piecewise function or as the 'rem' function:  <code>a @% b</code> will either
 * become
 *
 * <code>piecewise(a - b*ceil(a/b), xor((a < 0), (b < 0)), a - b*floor(a/b))</code>
 *
 * or 
 *
 * <code>rem(a, b)</code>.
 *
 * The latter is simpler, but the @c rem MathML is only allowed
 * as of SBML Level&nbsp;3 Version&nbsp;2.</li>
 *
 * <li style='margin-bottom: 0.5em'> A Model object may optionally be
 * provided to the parser using the variant function call
 * @sbmlfunction{parseL3FormulaWithModel, String\, Model} or
 * stored in a L3ParserSettings object passed to the variant function
 * @sbmlfunction{parseL3FormulaWithSettings, String\,
 * L3ParserSettings}.  When a Model object is provided, identifiers
 * (values of type @c SId ) from that model are used in preference to
 * pre-defined MathML definitions for both symbols and functions.
 * More precisely:
 * <ul style='list-style-type: square'>
 *
 * <li style='margin-bottom: 0.5em'> <em>In the case of symbols</em>: the
 * Model entities whose identifiers will shadow identical symbols in the
 * mathematical formula are: Species, Compartment, Parameter, Reaction, and
 * SpeciesReference.  For instance, if the parser is given a Model containing
 * a Species with the identifier &quot;<code>pi</code>&quot;, and the formula
 * to be parsed is &quot;<code>3*pi</code>&quot;, the MathML produced will
 * contain the construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of
 * the construct <code>&lt;pi/&gt;</code>.
 *
 * <li style='margin-bottom: 0.5em'> <em>In the case of user-defined
 * functions</em>: when a Model object is provided, @c SId values of
 * user-defined functions present in the model will be used preferentially
 * over pre-defined MathML functions.  For example, if the passed-in Model
 * contains a FunctionDefinition object with the identifier
 * &quot;<code>sin</code>&quot;, that function will be used instead of the
 * predefined MathML function <code>&lt;sin/&gt;</code>.
 * </ul>
 *
 * <li style='margin-bottom: 0.5em'> An SBMLNamespaces object may optionally
 * be provided to identify SBML Level&nbsp;3 packages that extend the
 * syntax understood by the formula parser.  When the namespaces are provided,
 * the parser will interpret possible additional syntax defined by the libSBML
 * plug-ins implementing the SBML Level&nbsp;3 packages; for example, it may
 * understand vector/array extensions introduced by the SBML Level&nbsp;3 @em
 * Arrays package.
 * </ul>
 *
 * These configuration settings cannot be changed directly using the basic
 * parser and formatter functions, but @em can be changed on a per-call basis
 * by using the alternative functions @sbmlfunction{parseL3FormulaWithSettings,
 * String\, L3ParserSettings} and
 * @sbmlfunction{formulaToL3StringWithSettings, ASTNode\,
 * L3ParserSettings}.
 *
 * Neither SBML nor the MathML standard define a 'string-form' equivalent to
 * MathML expressions.  The approach taken by libSBML is to start with the
 * formula syntax defined by SBML Level&nbsp;1 (which in fact used a custom
 * text-string representation of formulas, and not MathML), and expand it to
 * include the functionality described above.  This formula syntax is based
 * mostly on C programming syntax, and may contain operators, function calls,
 * symbols, and white space characters.  The following table provides the
 * precedence rules for the different entities that may appear in formula
 * strings.
 *
 * @htmlinclude math-precedence-table-l3.html
 *
 * In the table above, @em operand implies the construct is an operand, @em
 * prefix implies the operation is applied to the following arguments, @em
 * unary implies there is one argument, and @em binary implies there are
 * two arguments.  The values in the <b>Precedence</b> column show how the
 * order of different types of operation are determined.  For example, the
 * expression <code>a + b * c</code> is evaluated as <code>a + (b * c)</code>
 * because the @c * operator has higher precedence.  The
 * <b>Associates</b> column shows how the order of similar precedence
 * operations is determined; for example, <code>a && b || c</code> is
 * evaluated as <code>(a && b) || c</code> because the @c && and @c ||
 * operators are left-associative and have the same precedence.
 *
 * The function call syntax consists of a function name, followed by optional
 * white space, followed by an opening parenthesis token, followed by a
 * sequence of zero or more arguments separated by commas (with each comma
 * optionally preceded and/or followed by zero or more white space
 * characters), followed by a closing parenthesis token.  The function name
 * must be chosen from one of the pre-defined functions in SBML or a
 * user-defined function in the model.  The following table lists the names
 * of certain common mathematical functions; this table corresponds to
 * Table&nbsp;6 in the <a target='_blank'
 * href='http://sbml.org/Documents/Specifications#SBML_Level_1_Version_2'>SBML
 * Level&nbsp;1 Version&nbsp;2 specification</a> with additions based on the
 * functions added in SBML Level 2 and Level 3:
 *
 * @htmlinclude string-functions-table-l3.html
 *
 * Parsing of the various MathML functions and constants are all
 * case-insensitive by default: function names such as <code>cos</code>,
 * <code>Cos</code> and <code>COS</code> are all parsed as the MathML cosine
 * operator, <code>&lt;cos&gt;</code>.  However, <em>when a Model object is
 * used</em> in conjunction with either
 * @sbmlfunction{parseL3FormulaWithModel, String\, Model} or
 * @sbmlfunction{parseL3FormulaWithSettings, String\,
 * L3ParserSettings}, any identifiers found in that model will be
 * parsed in a case-<em>sensitive</em> way.  For example, if a model contains
 * a Species having the identifier <code>Pi</code>, the parser will parse
 * &quot;<code>Pi</code>&quot; in the input as &quot;<code>&lt;ci&gt; Pi
 * &lt;/ci&gt;</code>&quot; but will continue to parse the symbols
 * &quot;<code>pi</code>&quot; and &quot;<code>PI</code>&quot; as
 * &quot;<code>&lt;pi&gt;</code>&quot;.
 *
 * As mentioned above, the manner in which the 'L3' versions of the formula
 * parser and formatter interpret the function &quot;<code>log</code>&quot;
 * can be changed.  To do so, callers should use the function
 * @sbmlfunction{parseL3FormulaWithSettings, String\,
 * L3ParserSettings} and pass it an appropriate L3ParserSettings
 * object.  By default, unlike the SBML Level&nbsp;1 parser implemented by
 * @sbmlfunction{parseFormula, String}, the string
 * &quot;<code>log</code>&quot; is interpreted as the base&nbsp;10 logarithm,
 * and @em not as the natural logarithm.  However, you can change the
 * interpretation to be base-10 log, natural log, or as an error; since the
 * name 'log' by itself is ambiguous, you require that the parser uses
 * @c log10 or @c ln instead, which are more clear.  Please refer to
 * @sbmlfunction{parseL3FormulaWithSettings, String\,
 * L3ParserSettings}.
 *
 * In addition, the following symbols will be translated to their MathML
 * equivalents, if no symbol with the same @c SId identifier string exists
 * in the Model object provided:
 *
 * @htmlinclude string-values-table-l3.html
 *
 * Again, as mentioned above, whether the string
 * &quot;<code>avogadro</code>&quot; is parsed as an AST node of type
 * @link libsbml#AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink or
 * @link libsbml#AST_NAME AST_NAME@endlink is configurable; use the version of
 * the parser function called @sbmlfunction{parseL3FormulaWithSettings,
 * String\, L3ParserSettings}.  This Avogadro-related
 * functionality is provided because SBML Level&nbsp;2 models may not use
 * @link libsbml#AST_NAME_AVOGADRO AST_NAME_AVOGADRO@endlink AST nodes.
 *
 *
 *
 * For more details about the parser, please see the definition of
 * L3ParserSettings and @sbmlfunction{parseL3Formula, String}.
 *
 * @see @sbmlfunction{parseL3Formula, String}
 * @see @sbmlfunction{parseL3FormulaWithSettings, String\, L3ParserSettings}
 * @see @sbmlfunction{formulaToL3StringWithSettings, ASTNode\, L3ParserSettings}
 * @see L3ParserSettings
 *
 * @if conly
 * @memberof L3ParserSettings_t
 * @endif
 */ public
 static L3ParserSettings getDefaultL3ParserSettings() {
    global::System.IntPtr cPtr = libsbmlPINVOKE.getDefaultL3ParserSettings();
    L3ParserSettings ret = (cPtr == global::System.IntPtr.Zero) ? null : new L3ParserSettings(cPtr, true);
    return ret;
  }

  
/**
 * Returns the last error reported by the 'L3' mathematical formula parser.
 *
 * If the functions @sbmlfunction{parseL3Formula, String},
 * @sbmlfunction{parseL3FormulaWithSettings, String\,
 * L3ParserSettings}, or @sbmlfunction{parseL3FormulaWithModel,
 * String\, Model} return @c null, an error is set internally.
 * This function allows callers to retrieve information about the error.
 *
 * @return a string describing the error that occurred.  This will contain
 * the input string the parser was trying to parse, the character it had
 * parsed when it encountered the error, and a description of the error.
 *
 * @see @sbmlfunction{parseL3Formula, String}
 * @see @sbmlfunction{parseL3FormulaWithSettings, String\, L3ParserSettings}
 * @see @sbmlfunction{parseL3FormulaWithModel, String\, Model}
 * @see @sbmlfunction{getDefaultL3ParserSettings,}
 *
 * @if conly
 * @memberof ASTNode_t
 * @endif
 */ public
 static string getLastParseL3Error() {
    string ret = libsbmlPINVOKE.getLastParseL3Error();
    return ret;
  }

  
/** */ /* libsbml-internal */ public
 static void SBML_deleteL3Parser() {
    libsbmlPINVOKE.SBML_deleteL3Parser();
  }

  public const string LIBSBML_DOTTED_VERSION = "5.17.0";
  public const int LIBSBML_VERSION = 51700;
  public const string LIBSBML_VERSION_STRING = "51700";
  // OperationReturnValues_t 
  public const int LIBSBML_OPERATION_SUCCESS = 0;
  public const int LIBSBML_INDEX_EXCEEDS_SIZE = -1;
  public const int LIBSBML_UNEXPECTED_ATTRIBUTE = -2;
  public const int LIBSBML_OPERATION_FAILED = -3;
  public const int LIBSBML_INVALID_ATTRIBUTE_VALUE = -4;
  public const int LIBSBML_INVALID_OBJECT = -5;
  public const int LIBSBML_DUPLICATE_OBJECT_ID = -6;
  public const int LIBSBML_LEVEL_MISMATCH = -7;
  public const int LIBSBML_VERSION_MISMATCH = -8;
  public const int LIBSBML_INVALID_XML_OPERATION = -9;
  public const int LIBSBML_NAMESPACES_MISMATCH = -10;
  public const int LIBSBML_DUPLICATE_ANNOTATION_NS = -11;
  public const int LIBSBML_ANNOTATION_NAME_NOT_FOUND = -12;
  public const int LIBSBML_ANNOTATION_NS_NOT_FOUND = -13;
  public const int LIBSBML_MISSING_METAID = -14;
  public const int LIBSBML_DEPRECATED_ATTRIBUTE = -15;
  public const int LIBSBML_USE_ID_ATTRIBUTE_FUNCTION = -16;
  public const int LIBSBML_PKG_VERSION_MISMATCH = -20;
  public const int LIBSBML_PKG_UNKNOWN = -21;
  public const int LIBSBML_PKG_UNKNOWN_VERSION = -22;
  public const int LIBSBML_PKG_DISABLED = -23;
  public const int LIBSBML_PKG_CONFLICTED_VERSION = -24;
  public const int LIBSBML_PKG_CONFLICT = -25;
  public const int LIBSBML_CONV_INVALID_TARGET_NAMESPACE = -30;
  public const int LIBSBML_CONV_PKG_CONVERSION_NOT_AVAILABLE = -31;
  public const int LIBSBML_CONV_INVALID_SRC_DOCUMENT = -32;
  public const int LIBSBML_CONV_CONVERSION_NOT_AVAILABLE = -33;
  public const int LIBSBML_CONV_PKG_CONSIDERED_UNKNOWN = -34;

  // SBMLTypeCode_t 
  public const int SBML_UNKNOWN = 0;
  public const int SBML_COMPARTMENT = 1;
  public const int SBML_COMPARTMENT_TYPE = 2;
  public const int SBML_CONSTRAINT = 3;
  public const int SBML_DOCUMENT = 4;
  public const int SBML_EVENT = 5;
  public const int SBML_EVENT_ASSIGNMENT = 6;
  public const int SBML_FUNCTION_DEFINITION = 7;
  public const int SBML_INITIAL_ASSIGNMENT = 8;
  public const int SBML_KINETIC_LAW = 9;
  public const int SBML_LIST_OF = 10;
  public const int SBML_MODEL = 11;
  public const int SBML_PARAMETER = 12;
  public const int SBML_REACTION = 13;
  public const int SBML_RULE = 14;
  public const int SBML_SPECIES = 15;
  public const int SBML_SPECIES_REFERENCE = 16;
  public const int SBML_SPECIES_TYPE = 17;
  public const int SBML_MODIFIER_SPECIES_REFERENCE = 18;
  public const int SBML_UNIT_DEFINITION = 19;
  public const int SBML_UNIT = 20;
  public const int SBML_ALGEBRAIC_RULE = 21;
  public const int SBML_ASSIGNMENT_RULE = 22;
  public const int SBML_RATE_RULE = 23;
  public const int SBML_SPECIES_CONCENTRATION_RULE = 24;
  public const int SBML_COMPARTMENT_VOLUME_RULE = 25;
  public const int SBML_PARAMETER_RULE = 26;
  public const int SBML_TRIGGER = 27;
  public const int SBML_DELAY = 28;
  public const int SBML_STOICHIOMETRY_MATH = 29;
  public const int SBML_LOCAL_PARAMETER = 30;
  public const int SBML_PRIORITY = 31;
  public const int SBML_GENERIC_SBASE = 32;

  public const int IdCheckON = 0x01;
  public const int IdCheckOFF = 0xfe;
  public const int SBMLCheckON = 0x02;
  public const int SBMLCheckOFF = 0xfd;
  public const int SBOCheckON = 0x04;
  public const int SBOCheckOFF = 0xfb;
  public const int MathCheckON = 0x08;
  public const int MathCheckOFF = 0xf7;
  public const int UnitsCheckON = 0x10;
  public const int UnitsCheckOFF = 0xef;
  public const int OverdeterCheckON = 0x20;
  public const int OverdeterCheckOFF = 0xdf;
  public const int PracticeCheckON = 0x40;
  public const int PracticeCheckOFF = 0xbf;
  public const int AllChecksON = 0x7f;
  // UnitKind_t 
  public const int UNIT_KIND_AMPERE = 0;
  public const int UNIT_KIND_AVOGADRO = UNIT_KIND_AMPERE + 1;
  public const int UNIT_KIND_BECQUEREL = UNIT_KIND_AVOGADRO + 1;
  public const int UNIT_KIND_CANDELA = UNIT_KIND_BECQUEREL + 1;
  public const int UNIT_KIND_CELSIUS = UNIT_KIND_CANDELA + 1;
  public const int UNIT_KIND_COULOMB = UNIT_KIND_CELSIUS + 1;
  public const int UNIT_KIND_DIMENSIONLESS = UNIT_KIND_COULOMB + 1;
  public const int UNIT_KIND_FARAD = UNIT_KIND_DIMENSIONLESS + 1;
  public const int UNIT_KIND_GRAM = UNIT_KIND_FARAD + 1;
  public const int UNIT_KIND_GRAY = UNIT_KIND_GRAM + 1;
  public const int UNIT_KIND_HENRY = UNIT_KIND_GRAY + 1;
  public const int UNIT_KIND_HERTZ = UNIT_KIND_HENRY + 1;
  public const int UNIT_KIND_ITEM = UNIT_KIND_HERTZ + 1;
  public const int UNIT_KIND_JOULE = UNIT_KIND_ITEM + 1;
  public const int UNIT_KIND_KATAL = UNIT_KIND_JOULE + 1;
  public const int UNIT_KIND_KELVIN = UNIT_KIND_KATAL + 1;
  public const int UNIT_KIND_KILOGRAM = UNIT_KIND_KELVIN + 1;
  public const int UNIT_KIND_LITER = UNIT_KIND_KILOGRAM + 1;
  public const int UNIT_KIND_LITRE = UNIT_KIND_LITER + 1;
  public const int UNIT_KIND_LUMEN = UNIT_KIND_LITRE + 1;
  public const int UNIT_KIND_LUX = UNIT_KIND_LUMEN + 1;
  public const int UNIT_KIND_METER = UNIT_KIND_LUX + 1;
  public const int UNIT_KIND_METRE = UNIT_KIND_METER + 1;
  public const int UNIT_KIND_MOLE = UNIT_KIND_METRE + 1;
  public const int UNIT_KIND_NEWTON = UNIT_KIND_MOLE + 1;
  public const int UNIT_KIND_OHM = UNIT_KIND_NEWTON + 1;
  public const int UNIT_KIND_PASCAL = UNIT_KIND_OHM + 1;
  public const int UNIT_KIND_RADIAN = UNIT_KIND_PASCAL + 1;
  public const int UNIT_KIND_SECOND = UNIT_KIND_RADIAN + 1;
  public const int UNIT_KIND_SIEMENS = UNIT_KIND_SECOND + 1;
  public const int UNIT_KIND_SIEVERT = UNIT_KIND_SIEMENS + 1;
  public const int UNIT_KIND_STERADIAN = UNIT_KIND_SIEVERT + 1;
  public const int UNIT_KIND_TESLA = UNIT_KIND_STERADIAN + 1;
  public const int UNIT_KIND_VOLT = UNIT_KIND_TESLA + 1;
  public const int UNIT_KIND_WATT = UNIT_KIND_VOLT + 1;
  public const int UNIT_KIND_WEBER = UNIT_KIND_WATT + 1;
  public const int UNIT_KIND_INVALID = UNIT_KIND_WEBER + 1;

  // RuleType_t 
  public const int RULE_TYPE_RATE = 0;
  public const int RULE_TYPE_SCALAR = RULE_TYPE_RATE + 1;
  public const int RULE_TYPE_INVALID = RULE_TYPE_SCALAR + 1;

  // ConversionOptionType_t 
  public const int CNV_TYPE_BOOL = 0;
  public const int CNV_TYPE_DOUBLE = CNV_TYPE_BOOL + 1;
  public const int CNV_TYPE_INT = CNV_TYPE_DOUBLE + 1;
  public const int CNV_TYPE_SINGLE = CNV_TYPE_INT + 1;
  public const int CNV_TYPE_STRING = CNV_TYPE_SINGLE + 1;

  // XMLErrorCode_t 
  public const int XMLUnknownError = 0;
  public const int XMLOutOfMemory = 1;
  public const int XMLFileUnreadable = 2;
  public const int XMLFileUnwritable = 3;
  public const int XMLFileOperationError = 4;
  public const int XMLNetworkAccessError = 5;
  public const int InternalXMLParserError = 101;
  public const int UnrecognizedXMLParserCode = 102;
  public const int XMLTranscoderError = 103;
  public const int MissingXMLDecl = 1001;
  public const int MissingXMLEncoding = 1002;
  public const int BadXMLDecl = 1003;
  public const int BadXMLDOCTYPE = 1004;
  public const int InvalidCharInXML = 1005;
  public const int BadlyFormedXML = 1006;
  public const int UnclosedXMLToken = 1007;
  public const int InvalidXMLConstruct = 1008;
  public const int XMLTagMismatch = 1009;
  public const int DuplicateXMLAttribute = 1010;
  public const int UndefinedXMLEntity = 1011;
  public const int BadProcessingInstruction = 1012;
  public const int BadXMLPrefix = 1013;
  public const int BadXMLPrefixValue = 1014;
  public const int MissingXMLRequiredAttribute = 1015;
  public const int XMLAttributeTypeMismatch = 1016;
  public const int XMLBadUTF8Content = 1017;
  public const int MissingXMLAttributeValue = 1018;
  public const int BadXMLAttributeValue = 1019;
  public const int BadXMLAttribute = 1020;
  public const int UnrecognizedXMLElement = 1021;
  public const int BadXMLComment = 1022;
  public const int BadXMLDeclLocation = 1023;
  public const int XMLUnexpectedEOF = 1024;
  public const int BadXMLIDValue = 1025;
  public const int BadXMLIDRef = 1026;
  public const int UninterpretableXMLContent = 1027;
  public const int BadXMLDocumentStructure = 1028;
  public const int InvalidAfterXMLContent = 1029;
  public const int XMLExpectedQuotedString = 1030;
  public const int XMLEmptyValueNotPermitted = 1031;
  public const int XMLBadNumber = 1032;
  public const int XMLBadColon = 1033;
  public const int MissingXMLElements = 1034;
  public const int XMLContentEmpty = 1035;
  public const int XMLErrorCodesUpperBound = 9999;

  // XMLErrorCategory_t 
  public const int LIBSBML_CAT_INTERNAL = 0;
  public const int LIBSBML_CAT_SYSTEM = LIBSBML_CAT_INTERNAL + 1;
  public const int LIBSBML_CAT_XML = LIBSBML_CAT_SYSTEM + 1;

  // XMLErrorSeverity_t 
  public const int LIBSBML_SEV_INFO = 0;
  public const int LIBSBML_SEV_WARNING = LIBSBML_SEV_INFO + 1;
  public const int LIBSBML_SEV_ERROR = LIBSBML_SEV_WARNING + 1;
  public const int LIBSBML_SEV_FATAL = LIBSBML_SEV_ERROR + 1;

  // XMLErrorSeverityOverride_t 
  public const int LIBSBML_OVERRIDE_DISABLED = 0;
  public const int LIBSBML_OVERRIDE_DONT_LOG = LIBSBML_OVERRIDE_DISABLED + 1;
  public const int LIBSBML_OVERRIDE_WARNING = LIBSBML_OVERRIDE_DONT_LOG + 1;
  public const int LIBSBML_OVERRIDE_ERROR = LIBSBML_OVERRIDE_WARNING + 1;

  // SBMLErrorCode_t 
  public const int UnknownError = 10000;
  public const int NotUTF8 = 10101;
  public const int UnrecognizedElement = 10102;
  public const int NotSchemaConformant = 10103;
  public const int L3NotSchemaConformant = 10104;
  public const int InvalidMathElement = 10201;
  public const int DisallowedMathMLSymbol = 10202;
  public const int DisallowedMathMLEncodingUse = 10203;
  public const int DisallowedDefinitionURLUse = 10204;
  public const int BadCsymbolDefinitionURLValue = 10205;
  public const int DisallowedMathTypeAttributeUse = 10206;
  public const int DisallowedMathTypeAttributeValue = 10207;
  public const int LambdaOnlyAllowedInFunctionDef = 10208;
  public const int BooleanOpsNeedBooleanArgs = 10209;
  public const int NumericOpsNeedNumericArgs = 10210;
  public const int ArgsToEqNeedSameType = 10211;
  public const int PiecewiseNeedsConsistentTypes = 10212;
  public const int PieceNeedsBoolean = 10213;
  public const int ApplyCiMustBeUserFunction = 10214;
  public const int ApplyCiMustBeModelComponent = 10215;
  public const int KineticLawParametersAreLocalOnly = 10216;
  public const int MathResultMustBeNumeric = 10217;
  public const int OpsNeedCorrectNumberOfArgs = 10218;
  public const int InvalidNoArgsPassedToFunctionDef = 10219;
  public const int DisallowedMathUnitsUse = 10220;
  public const int InvalidUnitsValue = 10221;
  public const int CiCannotReference0DCompartment = 10222;
  public const int RateOfTargetMustBeCi = 10223;
  public const int RateOfTargetCannotBeAssigned = 10224;
  public const int RateOfSpeciesTargetCompartmentNot = 10225;
  public const int DuplicateComponentId = 10301;
  public const int DuplicateUnitDefinitionId = 10302;
  public const int DuplicateLocalParameterId = 10303;
  public const int MultipleAssignmentOrRateRules = 10304;
  public const int MultipleEventAssignmentsForId = 10305;
  public const int EventAndAssignmentRuleForId = 10306;
  public const int DuplicateMetaId = 10307;
  public const int InvalidSBOTermSyntax = 10308;
  public const int InvalidMetaidSyntax = 10309;
  public const int InvalidIdSyntax = 10310;
  public const int InvalidUnitIdSyntax = 10311;
  public const int InvalidNameSyntax = 10312;
  public const int DanglingUnitReference = 10313;
  public const int MissingAnnotationNamespace = 10401;
  public const int DuplicateAnnotationNamespaces = 10402;
  public const int SBMLNamespaceInAnnotation = 10403;
  public const int MultipleAnnotations = 10404;
  public const int InconsistentArgUnits = 10501;
  public const int InconsistentKineticLawUnitsL3 = 10503;
  public const int AssignRuleCompartmentMismatch = 10511;
  public const int AssignRuleSpeciesMismatch = 10512;
  public const int AssignRuleParameterMismatch = 10513;
  public const int AssignRuleStoichiometryMismatch = 10514;
  public const int InitAssignCompartmenMismatch = 10521;
  public const int InitAssignSpeciesMismatch = 10522;
  public const int InitAssignParameterMismatch = 10523;
  public const int InitAssignStoichiometryMismatch = 10524;
  public const int RateRuleCompartmentMismatch = 10531;
  public const int RateRuleSpeciesMismatch = 10532;
  public const int RateRuleParameterMismatch = 10533;
  public const int RateRuleStoichiometryMismatch = 10534;
  public const int KineticLawNotSubstancePerTime = 10541;
  public const int SpeciesInvalidExtentUnits = 10542;
  public const int DelayUnitsNotTime = 10551;
  public const int EventAssignCompartmentMismatch = 10561;
  public const int EventAssignSpeciesMismatch = 10562;
  public const int EventAssignParameterMismatch = 10563;
  public const int EventAssignStoichiometryMismatch = 10564;
  public const int PriorityUnitsNotDimensionless = 10565;
  public const int UpperUnitBound = 10599;
  public const int OverdeterminedSystem = 10601;
  public const int InvalidModelSBOTerm = 10701;
  public const int InvalidFunctionDefSBOTerm = 10702;
  public const int InvalidParameterSBOTerm = 10703;
  public const int InvalidInitAssignSBOTerm = 10704;
  public const int InvalidRuleSBOTerm = 10705;
  public const int InvalidConstraintSBOTerm = 10706;
  public const int InvalidReactionSBOTerm = 10707;
  public const int InvalidSpeciesReferenceSBOTerm = 10708;
  public const int InvalidKineticLawSBOTerm = 10709;
  public const int InvalidEventSBOTerm = 10710;
  public const int InvalidEventAssignmentSBOTerm = 10711;
  public const int InvalidCompartmentSBOTerm = 10712;
  public const int InvalidSpeciesSBOTerm = 10713;
  public const int InvalidCompartmentTypeSBOTerm = 10714;
  public const int InvalidSpeciesTypeSBOTerm = 10715;
  public const int InvalidTriggerSBOTerm = 10716;
  public const int InvalidDelaySBOTerm = 10717;
  public const int InvalidLocalParameterSBOTerm = 10718;
  public const int InvalidSBMLElementSBOTerm = 10719;
  public const int NotesNotInXHTMLNamespace = 10801;
  public const int NotesContainsXMLDecl = 10802;
  public const int NotesContainsDOCTYPE = 10803;
  public const int InvalidNotesContent = 10804;
  public const int OnlyOneNotesElementAllowed = 10805;
  public const int InvalidNamespaceOnSBML = 20101;
  public const int MissingOrInconsistentLevel = 20102;
  public const int MissingOrInconsistentVersion = 20103;
  public const int PackageNSMustMatch = 20104;
  public const int LevelPositiveInteger = 20105;
  public const int VersionPositiveInteger = 20106;
  public const int AllowedAttributesOnSBML = 20108;
  public const int L3PackageOnLowerSBML = 20109;
  public const int MissingModel = 20201;
  public const int IncorrectOrderInModel = 20202;
  public const int EmptyListElement = 20203;
  public const int NeedCompartmentIfHaveSpecies = 20204;
  public const int OneOfEachListOf = 20205;
  public const int OnlyFuncDefsInListOfFuncDefs = 20206;
  public const int OnlyUnitDefsInListOfUnitDefs = 20207;
  public const int OnlyCompartmentsInListOfCompartments = 20208;
  public const int OnlySpeciesInListOfSpecies = 20209;
  public const int OnlyParametersInListOfParameters = 20210;
  public const int OnlyInitAssignsInListOfInitAssigns = 20211;
  public const int OnlyRulesInListOfRules = 20212;
  public const int OnlyConstraintsInListOfConstraints = 20213;
  public const int OnlyReactionsInListOfReactions = 20214;
  public const int OnlyEventsInListOfEvents = 20215;
  public const int L3ConversionFactorOnModel = 20216;
  public const int L3TimeUnitsOnModel = 20217;
  public const int L3VolumeUnitsOnModel = 20218;
  public const int L3AreaUnitsOnModel = 20219;
  public const int L3LengthUnitsOnModel = 20220;
  public const int L3ExtentUnitsOnModel = 20221;
  public const int AllowedAttributesOnModel = 20222;
  public const int AllowedAttributesOnListOfFuncs = 20223;
  public const int AllowedAttributesOnListOfUnitDefs = 20224;
  public const int AllowedAttributesOnListOfComps = 20225;
  public const int AllowedAttributesOnListOfSpecies = 20226;
  public const int AllowedAttributesOnListOfParams = 20227;
  public const int AllowedAttributesOnListOfInitAssign = 20228;
  public const int AllowedAttributesOnListOfRules = 20229;
  public const int AllowedAttributesOnListOfConstraints = 20230;
  public const int AllowedAttributesOnListOfReactions = 20231;
  public const int AllowedAttributesOnListOfEvents = 20232;
  public const int L3V2SubstanceUnitsOnModel = 20233;
  public const int FunctionDefMathNotLambda = 20301;
  public const int InvalidApplyCiInLambda = 20302;
  public const int RecursiveFunctionDefinition = 20303;
  public const int InvalidCiInLambda = 20304;
  public const int InvalidFunctionDefReturnType = 20305;
  public const int OneMathElementPerFunc = 20306;
  public const int AllowedAttributesOnFunc = 20307;
  public const int InvalidUnitDefId = 20401;
  public const int InvalidSubstanceRedefinition = 20402;
  public const int InvalidLengthRedefinition = 20403;
  public const int InvalidAreaRedefinition = 20404;
  public const int InvalidTimeRedefinition = 20405;
  public const int InvalidVolumeRedefinition = 20406;
  public const int VolumeLitreDefExponentNotOne = 20407;
  public const int VolumeMetreDefExponentNot3 = 20408;
  public const int EmptyListOfUnits = 20409;
  public const int InvalidUnitKind = 20410;
  public const int OffsetNoLongerValid = 20411;
  public const int CelsiusNoLongerValid = 20412;
  public const int EmptyUnitListElement = 20413;
  public const int OneListOfUnitsPerUnitDef = 20414;
  public const int OnlyUnitsInListOfUnits = 20415;
  public const int AllowedAttributesOnUnitDefinition = 20419;
  public const int AllowedAttributesOnListOfUnits = 20420;
  public const int AllowedAttributesOnUnit = 20421;
  public const int ZeroDimensionalCompartmentSize = 20501;
  public const int ZeroDimensionalCompartmentUnits = 20502;
  public const int ZeroDimensionalCompartmentConst = 20503;
  public const int UndefinedOutsideCompartment = 20504;
  public const int RecursiveCompartmentContainment = 20505;
  public const int ZeroDCompartmentContainment = 20506;
  public const int Invalid1DCompartmentUnits = 20507;
  public const int Invalid2DCompartmentUnits = 20508;
  public const int Invalid3DCompartmentUnits = 20509;
  public const int InvalidCompartmentTypeRef = 20510;
  public const int OneDimensionalCompartmentUnits = 20511;
  public const int TwoDimensionalCompartmentUnits = 20512;
  public const int ThreeDimensionalCompartmentUnits = 20513;
  public const int AllowedAttributesOnCompartment = 20517;
  public const int NoUnitsOnCompartment = 20518;
  public const int InvalidSpeciesCompartmentRef = 20601;
  public const int HasOnlySubsNoSpatialUnits = 20602;
  public const int NoSpatialUnitsInZeroD = 20603;
  public const int NoConcentrationInZeroD = 20604;
  public const int SpatialUnitsInOneD = 20605;
  public const int SpatialUnitsInTwoD = 20606;
  public const int SpatialUnitsInThreeD = 20607;
  public const int InvalidSpeciesSusbstanceUnits = 20608;
  public const int BothAmountAndConcentrationSet = 20609;
  public const int NonBoundarySpeciesAssignedAndUsed = 20610;
  public const int NonConstantSpeciesUsed = 20611;
  public const int InvalidSpeciesTypeRef = 20612;
  public const int MultSpeciesSameTypeInCompartment = 20613;
  public const int MissingSpeciesCompartment = 20614;
  public const int SpatialSizeUnitsRemoved = 20615;
  public const int SubstanceUnitsOnSpecies = 20616;
  public const int ConversionFactorOnSpecies = 20617;
  public const int AllowedAttributesOnSpecies = 20623;
  public const int InvalidParameterUnits = 20701;
  public const int ParameterUnits = 20702;
  public const int ConversionFactorMustConstant = 20705;
  public const int AllowedAttributesOnParameter = 20706;
  public const int InvalidInitAssignSymbol = 20801;
  public const int MultipleInitAssignments = 20802;
  public const int InitAssignmentAndRuleForSameId = 20803;
  public const int OneMathElementPerInitialAssign = 20804;
  public const int AllowedAttributesOnInitialAssign = 20805;
  public const int InitAssignmentCannotRef0DComp = 20806;
  public const int InvalidAssignRuleVariable = 20901;
  public const int InvalidRateRuleVariable = 20902;
  public const int AssignmentToConstantEntity = 20903;
  public const int RateRuleForConstantEntity = 20904;
  public const int RepeatedRule10304 = 20905;
  public const int CircularRuleDependency = 20906;
  public const int OneMathElementPerRule = 20907;
  public const int AllowedAttributesOnAssignRule = 20908;
  public const int AllowedAttributesOnRateRule = 20909;
  public const int AllowedAttributesOnAlgRule = 20910;
  public const int RuleCannotRef0DComp = 20911;
  public const int CircularDependencyRateOf = 20912;
  public const int ConstraintMathNotBoolean = 21001;
  public const int IncorrectOrderInConstraint = 21002;
  public const int ConstraintNotInXHTMLNamespace = 21003;
  public const int ConstraintContainsXMLDecl = 21004;
  public const int ConstraintContainsDOCTYPE = 21005;
  public const int InvalidConstraintContent = 21006;
  public const int OneMathElementPerConstraint = 21007;
  public const int OneMessageElementPerConstraint = 21008;
  public const int AllowedAttributesOnConstraint = 21009;
  public const int NoReactantsOrProducts = 21101;
  public const int IncorrectOrderInReaction = 21102;
  public const int EmptyListInReaction = 21103;
  public const int InvalidReactantsProductsList = 21104;
  public const int InvalidModifiersList = 21105;
  public const int OneSubElementPerReaction = 21106;
  public const int CompartmentOnReaction = 21107;
  public const int AllowedAttributesOnReaction = 21110;
  public const int InvalidSpeciesReference = 21111;
  public const int RepeatedRule20611 = 21112;
  public const int BothStoichiometryAndMath = 21113;
  public const int AllowedAttributesOnSpeciesReference = 21116;
  public const int AllowedAttributesOnModifier = 21117;
  public const int UndeclaredSpeciesRef = 21121;
  public const int IncorrectOrderInKineticLaw = 21122;
  public const int EmptyListInKineticLaw = 21123;
  public const int NonConstantLocalParameter = 21124;
  public const int SubsUnitsNoLongerValid = 21125;
  public const int TimeUnitsNoLongerValid = 21126;
  public const int OneListOfPerKineticLaw = 21127;
  public const int OnlyLocalParamsInListOfLocalParams = 21128;
  public const int AllowedAttributesOnListOfLocalParam = 21129;
  public const int OneMathPerKineticLaw = 21130;
  public const int UndeclaredSpeciesInStoichMath = 21131;
  public const int AllowedAttributesOnKineticLaw = 21132;
  public const int AllowedAttributesOnListOfSpeciesRef = 21150;
  public const int AllowedAttributesOnListOfMods = 21151;
  public const int L3V2FastDeprecated = 21152;
  public const int AllowedAttributesOnLocalParameter = 21172;
  public const int LocalParameterShadowsSpecies = 21173;
  public const int MissingTriggerInEvent = 21201;
  public const int TriggerMathNotBoolean = 21202;
  public const int MissingEventAssignment = 21203;
  public const int TimeUnitsEvent = 21204;
  public const int IncorrectOrderInEvent = 21205;
  public const int ValuesFromTriggerTimeNeedDelay = 21206;
  public const int DelayNeedsValuesFromTriggerTime = 21207;
  public const int OneMathPerTrigger = 21209;
  public const int OneMathPerDelay = 21210;
  public const int InvalidEventAssignmentVariable = 21211;
  public const int EventAssignmentForConstantEntity = 21212;
  public const int OneMathPerEventAssignment = 21213;
  public const int AllowedAttributesOnEventAssignment = 21214;
  public const int OnlyOneDelayPerEvent = 21221;
  public const int OneListOfEventAssignmentsPerEvent = 21222;
  public const int OnlyEventAssignInListOfEventAssign = 21223;
  public const int AllowedAttributesOnListOfEventAssign = 21224;
  public const int AllowedAttributesOnEvent = 21225;
  public const int AllowedAttributesOnTrigger = 21226;
  public const int AllowedAttributesOnDelay = 21227;
  public const int PersistentNotBoolean = 21228;
  public const int InitialValueNotBoolean = 21229;
  public const int OnlyOnePriorityPerEvent = 21230;
  public const int OneMathPerPriority = 21231;
  public const int AllowedAttributesOnPriority = 21232;
  public const int GeneralWarningNotSpecified = 29999;
  public const int CompartmentShouldHaveSize = 80501;
  public const int SpeciesShouldHaveValue = 80601;
  public const int ParameterShouldHaveUnits = 80701;
  public const int ParameterShouldHaveValue = 80702;
  public const int LocalParameterShadowsId = 81121;
  public const int LibSBMLAdditionalCodesLowerBound = 90000;
  public const int CannotConvertToL1V1 = 90001;
  public const int NoEventsInL1 = 91001;
  public const int NoFunctionDefinitionsInL1 = 91002;
  public const int NoConstraintsInL1 = 91003;
  public const int NoInitialAssignmentsInL1 = 91004;
  public const int NoSpeciesTypesInL1 = 91005;
  public const int NoCompartmentTypeInL1 = 91006;
  public const int NoNon3DCompartmentsInL1 = 91007;
  public const int NoFancyStoichiometryMathInL1 = 91008;
  public const int NoNonIntegerStoichiometryInL1 = 91009;
  public const int NoUnitMultipliersOrOffsetsInL1 = 91010;
  public const int SpeciesCompartmentRequiredInL1 = 91011;
  public const int NoSpeciesSpatialSizeUnitsInL1 = 91012;
  public const int NoSBOTermsInL1 = 91013;
  public const int StrictUnitsRequiredInL1 = 91014;
  public const int ConversionFactorNotInL1 = 91015;
  public const int CompartmentNotOnL1Reaction = 91016;
  public const int ExtentUnitsNotSubstance = 91017;
  public const int GlobalUnitsNotDeclared = 91018;
  public const int HasOnlySubstanceUnitsNotinL1 = 91019;
  public const int AvogadroNotSupported = 91020;
  public const int NoConstraintsInL2v1 = 92001;
  public const int NoInitialAssignmentsInL2v1 = 92002;
  public const int NoSpeciesTypeInL2v1 = 92003;
  public const int NoCompartmentTypeInL2v1 = 92004;
  public const int NoSBOTermsInL2v1 = 92005;
  public const int NoIdOnSpeciesReferenceInL2v1 = 92006;
  public const int NoDelayedEventAssignmentInL2v1 = 92007;
  public const int StrictUnitsRequiredInL2v1 = 92008;
  public const int IntegerSpatialDimensions = 92009;
  public const int StoichiometryMathNotYetSupported = 92010;
  public const int PriorityLostFromL3 = 92011;
  public const int NonPersistentNotSupported = 92012;
  public const int InitialValueFalseEventNotSupported = 92013;
  public const int SBOTermNotUniversalInL2v2 = 93001;
  public const int NoUnitOffsetInL2v2 = 93002;
  public const int NoKineticLawTimeUnitsInL2v2 = 93003;
  public const int NoKineticLawSubstanceUnitsInL2v2 = 93004;
  public const int NoDelayedEventAssignmentInL2v2 = 93005;
  public const int ModelSBOBranchChangedBeyondL2v2 = 93006;
  public const int StrictUnitsRequiredInL2v2 = 93007;
  public const int StrictSBORequiredInL2v2 = 93008;
  public const int DuplicateAnnotationInvalidInL2v2 = 93009;
  public const int NoUnitOffsetInL2v3 = 94001;
  public const int NoKineticLawTimeUnitsInL2v3 = 94002;
  public const int NoKineticLawSubstanceUnitsInL2v3 = 94003;
  public const int NoSpeciesSpatialSizeUnitsInL2v3 = 94004;
  public const int NoEventTimeUnitsInL2v3 = 94005;
  public const int NoDelayedEventAssignmentInL2v3 = 94006;
  public const int ModelSBOBranchChangedBeyondL2v3 = 94007;
  public const int StrictUnitsRequiredInL2v3 = 94008;
  public const int StrictSBORequiredInL2v3 = 94009;
  public const int DuplicateAnnotationInvalidInL2v3 = 94010;
  public const int NoUnitOffsetInL2v4 = 95001;
  public const int NoKineticLawTimeUnitsInL2v4 = 95002;
  public const int NoKineticLawSubstanceUnitsInL2v4 = 95003;
  public const int NoSpeciesSpatialSizeUnitsInL2v4 = 95004;
  public const int NoEventTimeUnitsInL2v4 = 95005;
  public const int ModelSBOBranchChangedInL2v4 = 95006;
  public const int DuplicateAnnotationInvalidInL2v4 = 95007;
  public const int NoSpeciesTypeInL3v1 = 96001;
  public const int NoCompartmentTypeInL3v1 = 96002;
  public const int NoUnitOffsetInL3v1 = 96003;
  public const int NoKineticLawTimeUnitsInL3v1 = 96004;
  public const int NoKineticLawSubstanceUnitsInL3v1 = 96005;
  public const int NoSpeciesSpatialSizeUnitsInL3v1 = 96006;
  public const int NoEventTimeUnitsInL3v1 = 96007;
  public const int ModelSBOBranchChangedInL3v1 = 96008;
  public const int DuplicateAnnotationInvalidInL3v1 = 96009;
  public const int NoCompartmentOutsideInL3v1 = 96010;
  public const int NoStoichiometryMathInL3v1 = 96011;
  public const int DoubleExponentNotSupported = 98001;
  public const int MathMLElementNotSupported = 98002;
  public const int EmptyListOfElementNotSupported = 98003;
  public const int MissingMathElementNotSupported = 98004;
  public const int MissingTriggerElementNotSupported = 98005;
  public const int BooleanNumericDiscrepancy = 98006;
  public const int IdNameSBaseInL3V2 = 98007;
  public const int MissingParticipantsNotSupported = 98008;
  public const int ConvertibleMathInitialAssignment = 98009;
  public const int FastReactionsNotSupported = 98010;
  public const int SpeciesRefIdInMathMLNotSupported = 98011;
  public const int InvalidSBMLLevelVersion = 99101;
  public const int InvalidPackageLevelVersion = 99102;
  public const int AnnotationNotesNotAllowedLevel1 = 99104;
  public const int InvalidRuleOrdering = 99106;
  public const int RequiredPackagePresent = 99107;
  public const int UnrequiredPackagePresent = 99108;
  public const int PackageRequiredShouldBeFalse = 99109;
  public const int SubsUnitsAllowedInKL = 99127;
  public const int TimeUnitsAllowedInKL = 99128;
  public const int FormulaInLevel1KL = 99129;
  public const int L3SubstanceUnitsOnModel = 99130;
  public const int StoichiometryMathMissingMath = 99131;
  public const int TimeUnitsRemoved = 99206;
  public const int BadMathML = 99219;
  public const int FailedMathMLReadOfDouble = 99220;
  public const int FailedMathMLReadOfInteger = 99221;
  public const int FailedMathMLReadOfExponential = 99222;
  public const int FailedMathMLReadOfRational = 99223;
  public const int BadMathMLNodeType = 99224;
  public const int InvalidMathMLAttribute = 99225;
  public const int NoTimeSymbolInFunctionDef = 99301;
  public const int NoBodyInFunctionDef = 99302;
  public const int DanglingUnitSIdRef = 99303;
  public const int RDFMissingAboutTag = 99401;
  public const int RDFEmptyAboutTag = 99402;
  public const int RDFAboutTagNotMetaid = 99403;
  public const int RDFNotCompleteModelHistory = 99404;
  public const int RDFNotModelHistory = 99405;
  public const int AnnotationNotElement = 99406;
  public const int NestedAnnotationNotAllowed = 99407;
  public const int InconsistentArgUnitsWarnings = 99502;
  public const int InconsistentPowerUnitsWarnings = 99503;
  public const int InconsistentExponUnitsWarnings = 99504;
  public const int UndeclaredUnits = 99505;
  public const int UndeclaredTimeUnitsL3 = 99506;
  public const int UndeclaredExtentUnitsL3 = 99507;
  public const int UndeclaredObjectUnitsL3 = 99508;
  public const int CannotVerifyUnitsObjectNoMath = 99509;
  public const int UnrecognisedSBOTerm = 99701;
  public const int ObseleteSBOTerm = 99702;
  public const int IncorrectCompartmentSpatialDimensions = 99901;
  public const int CompartmentTypeNotValidAttribute = 99902;
  public const int ConstantNotValidAttribute = 99903;
  public const int MetaIdNotValidAttribute = 99904;
  public const int SBOTermNotValidAttributeBeforeL2V3 = 99905;
  public const int InvalidL1CompartmentUnits = 99906;
  public const int L1V1CompartmentVolumeReqd = 99907;
  public const int CompartmentTypeNotValidComponent = 99908;
  public const int ConstraintNotValidComponent = 99909;
  public const int EventNotValidComponent = 99910;
  public const int SBOTermNotValidAttributeBeforeL2V2 = 99911;
  public const int FuncDefNotValidComponent = 99912;
  public const int InitialAssignNotValidComponent = 99913;
  public const int VariableNotValidAttribute = 99914;
  public const int UnitsNotValidAttribute = 99915;
  public const int ConstantSpeciesNotValidAttribute = 99916;
  public const int SpatialSizeUnitsNotValidAttribute = 99917;
  public const int SpeciesTypeNotValidAttribute = 99918;
  public const int HasOnlySubsUnitsNotValidAttribute = 99919;
  public const int IdNotValidAttribute = 99920;
  public const int NameNotValidAttribute = 99921;
  public const int SpeciesTypeNotValidComponent = 99922;
  public const int StoichiometryMathNotValidComponent = 99923;
  public const int MultiplierNotValidAttribute = 99924;
  public const int OffsetNotValidAttribute = 99925;
  public const int L3SpatialDimensionsUnset = 99926;
  public const int UnknownCoreAttribute = 99994;
  public const int UnknownPackageAttribute = 99995;
  public const int PackageConversionNotSupported = 99996;
  public const int InvalidTargetLevelVersion = 99997;
  public const int L3NotSupported = 99998;
  public const int SBMLCodesUpperBound = 99999;

  // SBMLErrorCategory_t 
  public const int LIBSBML_CAT_SBML = (LIBSBML_CAT_XML+1);
  public const int LIBSBML_CAT_SBML_L1_COMPAT = LIBSBML_CAT_SBML + 1;
  public const int LIBSBML_CAT_SBML_L2V1_COMPAT = LIBSBML_CAT_SBML_L1_COMPAT + 1;
  public const int LIBSBML_CAT_SBML_L2V2_COMPAT = LIBSBML_CAT_SBML_L2V1_COMPAT + 1;
  public const int LIBSBML_CAT_GENERAL_CONSISTENCY = LIBSBML_CAT_SBML_L2V2_COMPAT + 1;
  public const int LIBSBML_CAT_IDENTIFIER_CONSISTENCY = LIBSBML_CAT_GENERAL_CONSISTENCY + 1;
  public const int LIBSBML_CAT_UNITS_CONSISTENCY = LIBSBML_CAT_IDENTIFIER_CONSISTENCY + 1;
  public const int LIBSBML_CAT_MATHML_CONSISTENCY = LIBSBML_CAT_UNITS_CONSISTENCY + 1;
  public const int LIBSBML_CAT_SBO_CONSISTENCY = LIBSBML_CAT_MATHML_CONSISTENCY + 1;
  public const int LIBSBML_CAT_OVERDETERMINED_MODEL = LIBSBML_CAT_SBO_CONSISTENCY + 1;
  public const int LIBSBML_CAT_SBML_L2V3_COMPAT = LIBSBML_CAT_OVERDETERMINED_MODEL + 1;
  public const int LIBSBML_CAT_MODELING_PRACTICE = LIBSBML_CAT_SBML_L2V3_COMPAT + 1;
  public const int LIBSBML_CAT_INTERNAL_CONSISTENCY = LIBSBML_CAT_MODELING_PRACTICE + 1;
  public const int LIBSBML_CAT_SBML_L2V4_COMPAT = LIBSBML_CAT_INTERNAL_CONSISTENCY + 1;
  public const int LIBSBML_CAT_SBML_L3V1_COMPAT = LIBSBML_CAT_SBML_L2V4_COMPAT + 1;
  public const int LIBSBML_CAT_SBML_L3V2_COMPAT = LIBSBML_CAT_SBML_L3V1_COMPAT + 1;
  public const int LIBSBML_CAT_SBML_COMPATIBILITY = LIBSBML_CAT_SBML_L3V2_COMPAT + 1;

  // SBMLErrorSeverity_t 
  public const int LIBSBML_SEV_SCHEMA_ERROR = (LIBSBML_SEV_FATAL+1);
  public const int LIBSBML_SEV_GENERAL_WARNING = LIBSBML_SEV_SCHEMA_ERROR + 1;
  public const int LIBSBML_SEV_NOT_APPLICABLE = LIBSBML_SEV_GENERAL_WARNING + 1;

  // QualifierType_t 
  public const int MODEL_QUALIFIER = 0;
  public const int BIOLOGICAL_QUALIFIER = MODEL_QUALIFIER + 1;
  public const int UNKNOWN_QUALIFIER = BIOLOGICAL_QUALIFIER + 1;

  // ModelQualifierType_t 
  public const int BQM_IS = 0;
  public const int BQM_IS_DESCRIBED_BY = BQM_IS + 1;
  public const int BQM_IS_DERIVED_FROM = BQM_IS_DESCRIBED_BY + 1;
  public const int BQM_IS_INSTANCE_OF = BQM_IS_DERIVED_FROM + 1;
  public const int BQM_HAS_INSTANCE = BQM_IS_INSTANCE_OF + 1;
  public const int BQM_UNKNOWN = BQM_HAS_INSTANCE + 1;

  // BiolQualifierType_t 
  public const int BQB_IS = 0;
  public const int BQB_HAS_PART = BQB_IS + 1;
  public const int BQB_IS_PART_OF = BQB_HAS_PART + 1;
  public const int BQB_IS_VERSION_OF = BQB_IS_PART_OF + 1;
  public const int BQB_HAS_VERSION = BQB_IS_VERSION_OF + 1;
  public const int BQB_IS_HOMOLOG_TO = BQB_HAS_VERSION + 1;
  public const int BQB_IS_DESCRIBED_BY = BQB_IS_HOMOLOG_TO + 1;
  public const int BQB_IS_ENCODED_BY = BQB_IS_DESCRIBED_BY + 1;
  public const int BQB_ENCODES = BQB_IS_ENCODED_BY + 1;
  public const int BQB_OCCURS_IN = BQB_ENCODES + 1;
  public const int BQB_HAS_PROPERTY = BQB_OCCURS_IN + 1;
  public const int BQB_IS_PROPERTY_OF = BQB_HAS_PROPERTY + 1;
  public const int BQB_HAS_TAXON = BQB_IS_PROPERTY_OF + 1;
  public const int BQB_UNKNOWN = BQB_HAS_TAXON + 1;

  // ASTNodeType_t 
  public const int AST_PLUS = '+';
  public const int AST_MINUS = '-';
  public const int AST_TIMES = '*';
  public const int AST_DIVIDE = '/';
  public const int AST_POWER = '^';
  public const int AST_INTEGER = 256;
  public const int AST_REAL = AST_INTEGER + 1;
  public const int AST_REAL_E = AST_REAL + 1;
  public const int AST_RATIONAL = AST_REAL_E + 1;
  public const int AST_NAME = AST_RATIONAL + 1;
  public const int AST_NAME_AVOGADRO = AST_NAME + 1;
  public const int AST_NAME_TIME = AST_NAME_AVOGADRO + 1;
  public const int AST_CONSTANT_E = AST_NAME_TIME + 1;
  public const int AST_CONSTANT_FALSE = AST_CONSTANT_E + 1;
  public const int AST_CONSTANT_PI = AST_CONSTANT_FALSE + 1;
  public const int AST_CONSTANT_TRUE = AST_CONSTANT_PI + 1;
  public const int AST_LAMBDA = AST_CONSTANT_TRUE + 1;
  public const int AST_FUNCTION = AST_LAMBDA + 1;
  public const int AST_FUNCTION_ABS = AST_FUNCTION + 1;
  public const int AST_FUNCTION_ARCCOS = AST_FUNCTION_ABS + 1;
  public const int AST_FUNCTION_ARCCOSH = AST_FUNCTION_ARCCOS + 1;
  public const int AST_FUNCTION_ARCCOT = AST_FUNCTION_ARCCOSH + 1;
  public const int AST_FUNCTION_ARCCOTH = AST_FUNCTION_ARCCOT + 1;
  public const int AST_FUNCTION_ARCCSC = AST_FUNCTION_ARCCOTH + 1;
  public const int AST_FUNCTION_ARCCSCH = AST_FUNCTION_ARCCSC + 1;
  public const int AST_FUNCTION_ARCSEC = AST_FUNCTION_ARCCSCH + 1;
  public const int AST_FUNCTION_ARCSECH = AST_FUNCTION_ARCSEC + 1;
  public const int AST_FUNCTION_ARCSIN = AST_FUNCTION_ARCSECH + 1;
  public const int AST_FUNCTION_ARCSINH = AST_FUNCTION_ARCSIN + 1;
  public const int AST_FUNCTION_ARCTAN = AST_FUNCTION_ARCSINH + 1;
  public const int AST_FUNCTION_ARCTANH = AST_FUNCTION_ARCTAN + 1;
  public const int AST_FUNCTION_CEILING = AST_FUNCTION_ARCTANH + 1;
  public const int AST_FUNCTION_COS = AST_FUNCTION_CEILING + 1;
  public const int AST_FUNCTION_COSH = AST_FUNCTION_COS + 1;
  public const int AST_FUNCTION_COT = AST_FUNCTION_COSH + 1;
  public const int AST_FUNCTION_COTH = AST_FUNCTION_COT + 1;
  public const int AST_FUNCTION_CSC = AST_FUNCTION_COTH + 1;
  public const int AST_FUNCTION_CSCH = AST_FUNCTION_CSC + 1;
  public const int AST_FUNCTION_DELAY = AST_FUNCTION_CSCH + 1;
  public const int AST_FUNCTION_EXP = AST_FUNCTION_DELAY + 1;
  public const int AST_FUNCTION_FACTORIAL = AST_FUNCTION_EXP + 1;
  public const int AST_FUNCTION_FLOOR = AST_FUNCTION_FACTORIAL + 1;
  public const int AST_FUNCTION_LN = AST_FUNCTION_FLOOR + 1;
  public const int AST_FUNCTION_LOG = AST_FUNCTION_LN + 1;
  public const int AST_FUNCTION_PIECEWISE = AST_FUNCTION_LOG + 1;
  public const int AST_FUNCTION_POWER = AST_FUNCTION_PIECEWISE + 1;
  public const int AST_FUNCTION_ROOT = AST_FUNCTION_POWER + 1;
  public const int AST_FUNCTION_SEC = AST_FUNCTION_ROOT + 1;
  public const int AST_FUNCTION_SECH = AST_FUNCTION_SEC + 1;
  public const int AST_FUNCTION_SIN = AST_FUNCTION_SECH + 1;
  public const int AST_FUNCTION_SINH = AST_FUNCTION_SIN + 1;
  public const int AST_FUNCTION_TAN = AST_FUNCTION_SINH + 1;
  public const int AST_FUNCTION_TANH = AST_FUNCTION_TAN + 1;
  public const int AST_LOGICAL_AND = AST_FUNCTION_TANH + 1;
  public const int AST_LOGICAL_NOT = AST_LOGICAL_AND + 1;
  public const int AST_LOGICAL_OR = AST_LOGICAL_NOT + 1;
  public const int AST_LOGICAL_XOR = AST_LOGICAL_OR + 1;
  public const int AST_RELATIONAL_EQ = AST_LOGICAL_XOR + 1;
  public const int AST_RELATIONAL_GEQ = AST_RELATIONAL_EQ + 1;
  public const int AST_RELATIONAL_GT = AST_RELATIONAL_GEQ + 1;
  public const int AST_RELATIONAL_LEQ = AST_RELATIONAL_GT + 1;
  public const int AST_RELATIONAL_LT = AST_RELATIONAL_LEQ + 1;
  public const int AST_RELATIONAL_NEQ = AST_RELATIONAL_LT + 1;
  public const int AST_QUALIFIER_BVAR = AST_RELATIONAL_NEQ + 1;
  public const int AST_QUALIFIER_LOGBASE = AST_QUALIFIER_BVAR + 1;
  public const int AST_QUALIFIER_DEGREE = AST_QUALIFIER_LOGBASE + 1;
  public const int AST_SEMANTICS = AST_QUALIFIER_DEGREE + 1;
  public const int AST_CONSTRUCTOR_PIECE = AST_SEMANTICS + 1;
  public const int AST_CONSTRUCTOR_OTHERWISE = AST_CONSTRUCTOR_PIECE + 1;
  public const int AST_FUNCTION_MAX = AST_CONSTRUCTOR_OTHERWISE + 1;
  public const int AST_FUNCTION_MIN = AST_FUNCTION_MAX + 1;
  public const int AST_FUNCTION_QUOTIENT = AST_FUNCTION_MIN + 1;
  public const int AST_FUNCTION_RATE_OF = AST_FUNCTION_QUOTIENT + 1;
  public const int AST_FUNCTION_REM = AST_FUNCTION_RATE_OF + 1;
  public const int AST_LOGICAL_IMPLIES = AST_FUNCTION_REM + 1;
  public const int AST_CSYMBOL_FUNCTION = 400;
  public const int AST_UNKNOWN = AST_CSYMBOL_FUNCTION + 1;
  public const int AST_ORIGINATES_IN_PACKAGE = AST_UNKNOWN + 1;

  // AST_Class_TypeCode_t 
  public const int AST_TYPECODE_BASE = 0;
  public const int AST_TYPECODE_CN_BASE = AST_TYPECODE_BASE + 1;
  public const int AST_TYPECODE_FUNCTION_BASE = AST_TYPECODE_CN_BASE + 1;
  public const int AST_TYPECODE_NUMBER = AST_TYPECODE_FUNCTION_BASE + 1;
  public const int AST_TYPECODE_CN_INTEGER = AST_TYPECODE_NUMBER + 1;
  public const int AST_TYPECODE_CN_EXPONENTIAL = AST_TYPECODE_CN_INTEGER + 1;
  public const int AST_TYPECODE_CN_RATIONAL = AST_TYPECODE_CN_EXPONENTIAL + 1;
  public const int AST_TYPECODE_CN_REAL = AST_TYPECODE_CN_RATIONAL + 1;
  public const int AST_TYPECODE_CONSTANT_NUMBER = AST_TYPECODE_CN_REAL + 1;
  public const int AST_TYPECODE_CI_NUMBER = AST_TYPECODE_CONSTANT_NUMBER + 1;
  public const int AST_TYPECODE_CSYMBOL = AST_TYPECODE_CI_NUMBER + 1;
  public const int AST_TYPECODE_CSYMBOL_AVOGADRO = AST_TYPECODE_CSYMBOL + 1;
  public const int AST_TYPECODE_CSYMBOL_DELAY = AST_TYPECODE_CSYMBOL_AVOGADRO + 1;
  public const int AST_TYPECODE_CSYMBOL_TIME = AST_TYPECODE_CSYMBOL_DELAY + 1;
  public const int AST_TYPECODE_CSYMBOL_RATE_OF = AST_TYPECODE_CSYMBOL_TIME + 1;
  public const int AST_TYPECODE_FUNCTION = AST_TYPECODE_CSYMBOL_RATE_OF + 1;
  public const int AST_TYPECODE_FUNCTION_UNARY = AST_TYPECODE_FUNCTION + 1;
  public const int AST_TYPECODE_FUNCTION_BINARY = AST_TYPECODE_FUNCTION_UNARY + 1;
  public const int AST_TYPECODE_FUNCTION_NARY = AST_TYPECODE_FUNCTION_BINARY + 1;
  public const int AST_TYPECODE_FUNCTION_PIECEWISE = AST_TYPECODE_FUNCTION_NARY + 1;
  public const int AST_TYPECODE_FUNCTION_LAMBDA = AST_TYPECODE_FUNCTION_PIECEWISE + 1;
  public const int AST_TYPECODE_FUNCTION_CI = AST_TYPECODE_FUNCTION_LAMBDA + 1;
  public const int AST_TYPECODE_FUNCTION_SEMANTIC = AST_TYPECODE_FUNCTION_CI + 1;
  public const int AST_TYPECODE_FUNCTION_QUALIFIER = AST_TYPECODE_FUNCTION_SEMANTIC + 1;
  public const int AST_TYPECODE_ASTNODE = AST_TYPECODE_FUNCTION_QUALIFIER + 1;

  // ParseLogType_t 
  public const int L3P_PARSE_LOG_AS_LOG10 = 0;
  public const int L3P_PARSE_LOG_AS_LN = 1;
  public const int L3P_PARSE_LOG_AS_ERROR = 2;

  public const bool L3P_COLLAPSE_UNARY_MINUS = true;
  public const bool L3P_EXPAND_UNARY_MINUS = false;
  public const bool L3P_PARSE_UNITS = true;
  public const bool L3P_NO_UNITS = false;
  public const bool L3P_AVOGADRO_IS_CSYMBOL = true;
  public const bool L3P_AVOGADRO_IS_NAME = false;
  public const bool L3P_COMPARE_BUILTINS_CASE_INSENSITIVE = false;
  public const bool L3P_COMPARE_BUILTINS_CASE_SENSITIVE = true;
  public const bool L3P_MODULO_IS_REM = true;
  public const bool L3P_MODULO_IS_PIECEWISE = false;
  public const bool L3P_PARSE_L3V2_FUNCTIONS_DIRECTLY = true;
  public const bool L3P_PARSE_L3V2_FUNCTIONS_AS_GENERIC = false;
  // L3ParserGrammarLineType_t 
  public const int INFIX_SYNTAX_NAMED_SQUARE_BRACKETS = 0;
  public const int INFIX_SYNTAX_CURLY_BRACES = INFIX_SYNTAX_NAMED_SQUARE_BRACKETS + 1;
  public const int INFIX_SYNTAX_CURLY_BRACES_SEMICOLON = INFIX_SYNTAX_CURLY_BRACES + 1;

}

}
